/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.pinprompt.database;

import dev.hexedhero.pinprompt.PINPrompt;
import dev.hexedhero.pinprompt.database.IDatabaseConnector;
import dev.hexedhero.pinprompt.utils.Common;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SQLiteConnector
implements IDatabaseConnector {
    @NotNull
    private final File databaseFile = new File(PINPrompt.getInstance().getDataFolder(), "database.db");
    @Nullable
    private Connection connection = null;

    public SQLiteConnector() {
        if (!this.databaseFile.exists()) {
            try {
                if (!this.databaseFile.getParentFile().exists()) {
                    this.databaseFile.getParentFile().mkdir();
                }
                this.databaseFile.createNewFile();
            }
            catch (IOException iOException) {
                Common.tellConsole(true, "&cERROR CREATING DATABASE.DB FILE");
                iOException.printStackTrace();
            }
        }
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Common.tellConsole(true, "&cERROR SETTING UP JDBC DRIVER");
            classNotFoundException.printStackTrace();
        }
    }

    @Override
    public void closeConnections() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Connection getConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return this.connection;
            }
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.databaseFile.getAbsolutePath());
            return this.connection;
        }
        catch (SQLException sQLException) {
            Common.tellConsole(true, "&cERROR GETTING CONNECTION TO DATABASE");
            sQLException.printStackTrace();
            return null;
        }
    }
}

