/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.pinprompt.listeners;

import dev.hexedhero.pinprompt.PINPrompt;
import dev.hexedhero.pinprompt.enums.EPINOpenReason;
import dev.hexedhero.pinprompt.listeners.AuthMeSupport;
import dev.hexedhero.pinprompt.listeners.NormalSupport;
import dev.hexedhero.pinprompt.managers.BanManager;
import dev.hexedhero.pinprompt.managers.DataManager;
import dev.hexedhero.pinprompt.managers.FlyManager;
import dev.hexedhero.pinprompt.managers.InventoryManager;
import dev.hexedhero.pinprompt.managers.PINManager;
import dev.hexedhero.pinprompt.managers.SpectatorManager;
import dev.hexedhero.pinprompt.managers.TaskManager;
import dev.hexedhero.pinprompt.objects.PINPlayer;
import dev.hexedhero.pinprompt.utils.ColorHelper;
import dev.hexedhero.pinprompt.utils.Common;
import dev.hexedhero.pinprompt.utils.RegistrationHelper;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.plugin.Plugin;

public class JoinAndLeaveListener
implements Listener {
    public JoinAndLeaveListener() {
        if (Bukkit.getPluginManager().isPluginEnabled("AuthMe")) {
            Common.tellConsole(true, "&aFound AuthMe! Registering AuthMe support...");
            RegistrationHelper.registerListeners(new AuthMeSupport());
        } else {
            RegistrationHelper.registerListeners(new NormalSupport());
        }
    }

    public static void handlePreJoin(AsyncPlayerPreLoginEvent asyncPlayerPreLoginEvent) {
        if (asyncPlayerPreLoginEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            return;
        }
        Common.debugToConsole("Join/Leave", "Handling pre join for %uuid%".replace("%uuid%", asyncPlayerPreLoginEvent.getUniqueId().toString()));
        if (BanManager.getInstance().isUUIDBanned(asyncPlayerPreLoginEvent.getUniqueId())) {
            asyncPlayerPreLoginEvent.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_BANNED);
            asyncPlayerPreLoginEvent.setKickMessage(ColorHelper.colorize(Common.getLanguage("Banned", false)));
            return;
        }
        DataManager.getInstance().loadPINPlayer(asyncPlayerPreLoginEvent.getUniqueId());
    }

    public static void handleJoin(Player player) {
        Common.debugToConsole("Join/Leave", "Handling join for %uuid%".replace("%uuid%", player.getUniqueId().toString()));
        if (DataManager.getInstance().getPINPlayer(player.getUniqueId()).getPIN() == null) {
            if (player.hasPermission("pinprompt.force")) {
                Common.debugToConsole("Join/Leave", "%uuid% is forced to have a PIN, forcing PIN creation".replace("%uuid%", player.getUniqueId().toString()));
                InventoryManager.getInstance().openNewPINInventory(player, EPINOpenReason.CREATION_FORCE);
                return;
            }
            PINManager.getInstance().transferPlayer(player, false);
            return;
        }
        PINPlayer pINPlayer = DataManager.getInstance().getPINPlayer(player.getUniqueId());
        if (PINPrompt.getInstance().getConfig().getBoolean("Sessions.Enabled")) {
            long l = pINPlayer.getLastEnteredTime() != null ? pINPlayer.getLastEnteredTime() : 0L;
            if ((double)l + PINPrompt.getInstance().getConfig().getDouble("Sessions.Time") * 3600000.0 > (double)System.currentTimeMillis()) {
                Common.debugToConsole("Join/Leave", "%uuid% has PIN set but is within session time, not asking for PIN unless IP is different and is set to be remembered".replace("%uuid%", player.getUniqueId().toString()));
                if (!PINPrompt.getInstance().getConfig().getBoolean("Sessions.Remember IP")) {
                    PINManager.getInstance().transferPlayer(player, false);
                    return;
                }
                if (player.getAddress().getAddress().getHostAddress().equals(DataManager.getInstance().getPINPlayer(player.getUniqueId()).getLastEnteredIP())) {
                    Common.debugToConsole("Join/Leave", "%uuid%'s IP address is the same compared to the saved session".replace("%uuid%", player.getUniqueId().toString()));
                    PINManager.getInstance().transferPlayer(player, false);
                    return;
                }
                Common.debugToConsole("Join/Leave", "%uuid%'s session is invalid due to changed IP address".replace("%uuid%", player.getUniqueId().toString()));
            }
        }
        Common.debugToConsole("Join/Leave", "%uuid% has PIN set and needs to enter it".replace("%uuid%", player.getUniqueId().toString()));
        InventoryManager.getInstance().openNewPINInventory(player, EPINOpenReason.ENTER);
    }

    public static void handleLeave(Player player) {
        Common.debugToConsole("Join/Leave", "Handling leave for %uuid%".replace("%uuid%", player.getUniqueId().toString()));
        TaskManager.getInstance().cancelTimeOutTaskForPlayer(player);
        SpectatorManager.getInstance().removePlayerFromSavedSpectatorMode(player);
        FlyManager.getInstance().removePlayerFromSavedFlyMode(player);
        PINManager.getInstance().removePlayersEnteredPIN(player.getUniqueId());
        PINManager.getInstance().removePlayerFromNeedingPIN(player.getUniqueId());
        PINManager.getInstance().removePlayerFromCreatingPIN(player.getUniqueId());
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)PINPrompt.getInstance(), () -> {
            PINPlayer pINPlayer = DataManager.getInstance().getPINPlayer(player.getUniqueId());
            if (pINPlayer != null) {
                DataManager.getInstance().savePINPlayer(pINPlayer, true);
            }
        });
    }
}

