/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.pinprompt.managers;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import dev.hexedhero.pinprompt.PINPrompt;
import dev.hexedhero.pinprompt.api.PINBlacklistedEvent;
import dev.hexedhero.pinprompt.api.PINCorrectEvent;
import dev.hexedhero.pinprompt.api.PINCreationEvent;
import dev.hexedhero.pinprompt.api.PINIncorrectEvent;
import dev.hexedhero.pinprompt.managers.BanManager;
import dev.hexedhero.pinprompt.managers.DataManager;
import dev.hexedhero.pinprompt.managers.FlyManager;
import dev.hexedhero.pinprompt.managers.SpectatorManager;
import dev.hexedhero.pinprompt.managers.TaskManager;
import dev.hexedhero.pinprompt.objects.PINPlayer;
import dev.hexedhero.pinprompt.utils.ColorHelper;
import dev.hexedhero.pinprompt.utils.Common;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class PINManager {
    private static final String BUNGEECORD_CHANNEL = "BungeeCord";
    private final Set<UUID> playersNeedingPIN = new HashSet<UUID>(4);
    private final Set<UUID> playersCreatingPIN = new HashSet<UUID>(4);
    private final Map<UUID, String> playersEnteredPIN = new HashMap<UUID, String>(4);
    private final Map<UUID, Integer> playerPINAttempts = new HashMap<UUID, Integer>(4);
    private static PINManager instance;

    public static PINManager getInstance() {
        if (instance == null) {
            instance = new PINManager();
        }
        return instance;
    }

    private PINManager() {
        Common.tellConsole(true, "PINManager initialized!");
    }

    public void addPlayerToNeedingPIN(UUID uUID) {
        this.playersNeedingPIN.add(uUID);
    }

    public void removePlayerFromNeedingPIN(UUID uUID) {
        this.playersNeedingPIN.remove(uUID);
    }

    public boolean isPlayerNeedingPIN(UUID uUID) {
        return this.playersNeedingPIN.contains(uUID);
    }

    public void addPlayerToCreatingPIN(UUID uUID) {
        this.playersCreatingPIN.add(uUID);
    }

    public void removePlayerFromCreatingPIN(UUID uUID) {
        this.playersCreatingPIN.remove(uUID);
    }

    public boolean isPlayerCreatingPIN(UUID uUID) {
        return this.playersCreatingPIN.contains(uUID);
    }

    public String getPlayersEnteredPIN(UUID uUID) {
        return this.playersEnteredPIN.getOrDefault(uUID, "");
    }

    public void removePlayersEnteredPIN(UUID uUID) {
        this.playersEnteredPIN.remove(uUID);
    }

    public Integer getPlayerPINAttempts(UUID uUID) {
        return this.playerPINAttempts.getOrDefault(uUID, 0);
    }

    public void increasePlayerPINAttempts(UUID uUID, int n) {
        this.playerPINAttempts.put(uUID, this.getPlayerPINAttempts(uUID) + 1);
    }

    public void removePlayerPINAttempts(UUID uUID) {
        this.playerPINAttempts.remove(uUID);
    }

    public boolean addPINNumber(Player player, String string) {
        Common.debugToConsole("PIN", "Adding %number% for %uuid%".replace("%number%", string).replace("%uuid%", player.getUniqueId().toString()));
        UUID uUID = player.getUniqueId();
        String string2 = "";
        if (!this.playersEnteredPIN.containsKey(uUID)) {
            this.playersEnteredPIN.put(uUID, string);
        } else {
            string2 = this.playersEnteredPIN.get(uUID) + string;
            this.playersEnteredPIN.put(uUID, string2);
        }
        if (string2.length() >= Math.min(Math.max(PINPrompt.getInstance().getConfig().getInt("PIN Settings.PIN Length"), 4), 8) && this.isPlayerCreatingPIN(uUID)) {
            Common.debugToConsole("PIN", "Setting %PIN% for %uuid%".replace("%PIN%", string2).replace("%uuid%", player.getUniqueId().toString()));
            if (PINPrompt.getInstance().getConfig().getStringList("PIN Settings.Blacklist").contains(string2)) {
                Common.debugToConsole("PIN", "%PIN% for %uuid% is blacklisted, declining...".replace("%PIN%", string2).replace("%uuid%", player.getUniqueId().toString()));
                this.increasePlayerPINAttempts(uUID, 1);
                this.playersEnteredPIN.remove(uUID);
                Common.playSound(player, player.getLocation(), Common.getSound("Blacklisted PIN"));
                PINBlacklistedEvent pINBlacklistedEvent = new PINBlacklistedEvent(player);
                Bukkit.getPluginManager().callEvent((Event)pINBlacklistedEvent);
                return false;
            }
            this.handleSavedModes(player);
            Common.tell((CommandSender)player, Common.getLanguage("Set New PIN", true));
            Common.sendTitle(player, Common.getLanguage("Set New PIN Title", false), Common.getLanguage("Set New PIN Subtitle", false));
            Common.playSound(player, player.getLocation(), Common.getSound("Set New PIN"));
            player.closeInventory();
            PINPlayer pINPlayer = DataManager.getInstance().getPINPlayer(uUID);
            pINPlayer.setPIN(string2);
            pINPlayer.setLastEnteredTime(System.currentTimeMillis());
            pINPlayer.setLastEnteredIP(player.getAddress().getAddress().getHostAddress());
            this.removePlayerFromCreatingPIN(uUID);
            this.playersEnteredPIN.remove(uUID);
            TaskManager.getInstance().cancelTimeOutTaskForPlayer(player);
            PINCreationEvent pINCreationEvent = new PINCreationEvent(player);
            Bukkit.getPluginManager().callEvent((Event)pINCreationEvent);
            this.transferPlayer(player, true);
            return true;
        }
        if (string2.length() >= Math.min(Math.max(PINPrompt.getInstance().getConfig().getInt("PIN Settings.PIN Length"), 4), 8) && string2.equalsIgnoreCase(DataManager.getInstance().getPINPlayer(uUID).getPIN())) {
            Common.debugToConsole("PIN", "%uuid% entered the correct PIN (%PIN%)".replace("%uuid%", player.getUniqueId().toString().replace("%PIN%", string2)));
            this.handleSavedModes(player);
            Common.tell((CommandSender)player, Common.getLanguage("Correct PIN", true));
            Common.sendTitle(player, Common.getLanguage("Correct PIN Title", false), Common.getLanguage("Correct PIN Subtitle", false));
            Common.playSound(player, player.getLocation(), Common.getSound("Correct PIN"));
            player.closeInventory();
            PINPlayer pINPlayer = DataManager.getInstance().getPINPlayer(uUID);
            pINPlayer.setLastEnteredTime(System.currentTimeMillis());
            pINPlayer.setLastEnteredIP(player.getAddress().getAddress().getHostAddress());
            this.removePlayerFromNeedingPIN(uUID);
            this.playersEnteredPIN.remove(uUID);
            PINManager.getInstance().removePlayerPINAttempts(uUID);
            TaskManager.getInstance().cancelTimeOutTaskForPlayer(player);
            PINCorrectEvent pINCorrectEvent = new PINCorrectEvent(player);
            Bukkit.getPluginManager().callEvent((Event)pINCorrectEvent);
            this.transferPlayer(player, true);
            return true;
        }
        if (string2.length() >= Math.min(Math.max(PINPrompt.getInstance().getConfig().getInt("PIN Settings.PIN Length"), 4), 8)) {
            Common.debugToConsole("PIN", "%uuid% entered the incorrect PIN (%PIN%)".replace("%uuid%", player.getUniqueId().toString().replace("%PIN%", string2)));
            this.increasePlayerPINAttempts(uUID, 1);
            if (this.getPlayerPINAttempts(uUID) >= PINPrompt.getInstance().getConfig().getInt("PIN Settings.Max Attempts")) {
                this.handleSavedModes(player);
                player.kickPlayer(ColorHelper.colorize(Common.getLanguage("Incorrect PIN", false)));
                if (PINPrompt.getInstance().getConfig().getDouble("PIN Settings.Ban Length") > 0.0) {
                    BanManager.getInstance().banUUID(uUID, PINPrompt.getInstance().getConfig().getDouble("PIN Settings.Ban Length") * 20.0);
                }
                PINManager.getInstance().removePlayerPINAttempts(uUID);
                return false;
            }
            this.playersEnteredPIN.remove(uUID);
            Common.playSound(player, player.getLocation(), Common.getSound("Incorrect PIN"));
            PINIncorrectEvent pINIncorrectEvent = new PINIncorrectEvent(player);
            Bukkit.getPluginManager().callEvent((Event)pINIncorrectEvent);
            return false;
        }
        return false;
    }

    public void transferPlayer(Player player, boolean bl) {
        if (!PINPrompt.getInstance().getConfig().getBoolean("Transfer.Enabled")) {
            return;
        }
        if (!bl && !PINPrompt.getInstance().getConfig().getBoolean("Transfer.Everyone")) {
            return;
        }
        if (!Bukkit.getMessenger().isOutgoingChannelRegistered((Plugin)PINPrompt.getInstance(), BUNGEECORD_CHANNEL)) {
            Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)PINPrompt.getInstance(), BUNGEECORD_CHANNEL);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)PINPrompt.getInstance(), () -> {
            String string = PINPrompt.getInstance().getConfig().getString("Transfer.Server");
            Common.debugToConsole("Transfer", "Tranfering %uuid% to server %server%".replace("%uuid%", player.getUniqueId().toString()).replace("%server%", string));
            ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
            byteArrayDataOutput.writeUTF("Connect");
            byteArrayDataOutput.writeUTF(string);
            player.sendPluginMessage((Plugin)PINPrompt.getInstance(), BUNGEECORD_CHANNEL, byteArrayDataOutput.toByteArray());
        }, 5L);
    }

    public void handleSavedModes(Player player) {
        if (SpectatorManager.getInstance().isPlayerInSavedSpectatorMode(player)) {
            player.setGameMode(GameMode.valueOf((String)PINPrompt.getInstance().getConfig().getString("Spectator Mode Handler.Switch Back")));
            SpectatorManager.getInstance().removePlayerFromSavedSpectatorMode(player);
        }
        if (FlyManager.getInstance().isPlayerInSavedFlyMode(player)) {
            player.setFlying(false);
            player.setAllowFlight(false);
            FlyManager.getInstance().removePlayerFromSavedFlyMode(player);
        }
        if (player.hasPotionEffect(PotionEffectType.BLINDNESS)) {
            player.removePotionEffect(PotionEffectType.BLINDNESS);
        }
    }
}

