/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.pinprompt.managers;

import dev.hexedhero.pinprompt.PINPrompt;
import dev.hexedhero.pinprompt.enums.EPINOpenReason;
import dev.hexedhero.pinprompt.utils.Common;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public class TeleportManager {
    private static TeleportManager instance;

    public static TeleportManager getInstance() {
        if (instance == null) {
            instance = new TeleportManager();
        }
        return instance;
    }

    private TeleportManager() {
        Common.tellConsole(true, "TeleportManager initialized!");
    }

    public void teleportPlayer(Player player, EPINOpenReason ePINOpenReason) {
        if (PINPrompt.getInstance().getConfig().getBoolean("Teleport.Enabled") && this.isEnabled(ePINOpenReason)) {
            World world = Bukkit.getWorld((String)PINPrompt.getInstance().getConfig().getString("Teleport.Location.World"));
            double d = PINPrompt.getInstance().getConfig().getInt("Teleport.Location.X");
            double d2 = PINPrompt.getInstance().getConfig().getInt("Teleport.Location.Y");
            double d3 = PINPrompt.getInstance().getConfig().getInt("Teleport.Location.Z");
            float f = PINPrompt.getInstance().getConfig().getInt("Teleport.Location.Yaw");
            float f2 = PINPrompt.getInstance().getConfig().getInt("Teleport.Location.Pitch");
            Location location = new Location(world, d, d2, d3, f, f2);
            player.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
        }
    }

    private boolean isEnabled(EPINOpenReason ePINOpenReason) {
        return PINPrompt.getInstance().getConfig().getStringList("Teleport.Reasons").stream().map(String::toLowerCase).collect(Collectors.toList()).contains(ePINOpenReason.toString().toLowerCase());
    }
}

