/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.pinprompt.shaded.hikari.pool;

import dev.hexedhero.pinprompt.shaded.hikari.pool.HikariPool;
import dev.hexedhero.pinprompt.shaded.hikari.pool.PoolBase;
import dev.hexedhero.pinprompt.shaded.hikari.pool.ProxyConnection;
import dev.hexedhero.pinprompt.shaded.hikari.pool.ProxyFactory;
import dev.hexedhero.pinprompt.shaded.hikari.pool.ProxyLeakTask;
import dev.hexedhero.pinprompt.shaded.hikari.util.ClockSource;
import dev.hexedhero.pinprompt.shaded.hikari.util.ConcurrentBag;
import dev.hexedhero.pinprompt.shaded.hikari.util.FastList;
import dev.hexedhero.pinprompt.shaded.slf4j.Logger;
import dev.hexedhero.pinprompt.shaded.slf4j.LoggerFactory;
import java.sql.Connection;
import java.sql.Statement;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class PoolEntry
implements ConcurrentBag.IConcurrentBagEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoolEntry.class);
    private static final AtomicIntegerFieldUpdater<PoolEntry> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(PoolEntry.class, "state");
    Connection connection;
    long lastAccessed;
    long lastBorrowed;
    private volatile int state = 0;
    private volatile boolean evict;
    private volatile ScheduledFuture<?> endOfLife;
    private volatile ScheduledFuture<?> keepalive;
    private final FastList<Statement> openStatements;
    private final HikariPool hikariPool;
    private final boolean isReadOnly;
    private final boolean isAutoCommit;

    PoolEntry(Connection connection, PoolBase poolBase, boolean bl, boolean bl2) {
        this.connection = connection;
        this.hikariPool = (HikariPool)poolBase;
        this.isReadOnly = bl;
        this.isAutoCommit = bl2;
        this.lastAccessed = ClockSource.currentTime();
        this.openStatements = new FastList(Statement.class, 16);
    }

    void recycle(long l) {
        if (this.connection != null) {
            this.lastAccessed = l;
            this.hikariPool.recycle(this);
        }
    }

    void setFutureEol(ScheduledFuture<?> scheduledFuture) {
        this.endOfLife = scheduledFuture;
    }

    public void setKeepalive(ScheduledFuture<?> scheduledFuture) {
        this.keepalive = scheduledFuture;
    }

    Connection createProxyConnection(ProxyLeakTask proxyLeakTask, long l) {
        return ProxyFactory.getProxyConnection(this, this.connection, this.openStatements, proxyLeakTask, l, this.isReadOnly, this.isAutoCommit);
    }

    void resetConnectionState(ProxyConnection proxyConnection, int n) {
        this.hikariPool.resetConnectionState(this.connection, proxyConnection, n);
    }

    String getPoolName() {
        return this.hikariPool.toString();
    }

    boolean isMarkedEvicted() {
        return this.evict;
    }

    void markEvicted() {
        this.evict = true;
    }

    void evict(String string) {
        this.hikariPool.closeConnection(this, string);
    }

    long getMillisSinceBorrowed() {
        return ClockSource.elapsedMillis(this.lastBorrowed);
    }

    PoolBase getPoolBase() {
        return this.hikariPool;
    }

    public String toString() {
        long l = ClockSource.currentTime();
        return this.connection + ", accessed " + ClockSource.elapsedDisplayString(this.lastAccessed, l) + " ago, " + this.stateToString();
    }

    @Override
    public int getState() {
        return stateUpdater.get(this);
    }

    @Override
    public boolean compareAndSet(int n, int n2) {
        return stateUpdater.compareAndSet(this, n, n2);
    }

    @Override
    public void setState(int n) {
        stateUpdater.set(this, n);
    }

    Connection close() {
        ScheduledFuture<?> scheduledFuture;
        ScheduledFuture<?> scheduledFuture2 = this.endOfLife;
        if (scheduledFuture2 != null && !scheduledFuture2.isDone() && !scheduledFuture2.cancel(false)) {
            LOGGER.warn("{} - maxLifeTime expiration task cancellation unexpectedly returned false for connection {}", (Object)this.getPoolName(), (Object)this.connection);
        }
        if ((scheduledFuture = this.keepalive) != null && !scheduledFuture.isDone() && !scheduledFuture.cancel(false)) {
            LOGGER.warn("{} - keepalive task cancellation unexpectedly returned false for connection {}", (Object)this.getPoolName(), (Object)this.connection);
        }
        Connection connection = this.connection;
        this.connection = null;
        this.endOfLife = null;
        this.keepalive = null;
        return connection;
    }

    private String stateToString() {
        switch (this.state) {
            case 1: {
                return "IN_USE";
            }
            case 0: {
                return "NOT_IN_USE";
            }
            case -1: {
                return "REMOVED";
            }
            case -2: {
                return "RESERVED";
            }
        }
        return "Invalid";
    }
}

