/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.pinprompt.tasks;

import dev.hexedhero.pinprompt.PINPrompt;
import dev.hexedhero.pinprompt.managers.DataManager;
import dev.hexedhero.pinprompt.managers.InventoryManager;
import dev.hexedhero.pinprompt.managers.PINManager;
import dev.hexedhero.pinprompt.utils.ColorHelper;
import dev.hexedhero.pinprompt.utils.Common;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerInGUITask
extends BukkitRunnable {
    private static final PotionEffect BLINDNESS_POTION = new PotionEffect(PotionEffectType.BLINDNESS, 120, 9, true, false);
    private final Player player;
    private final UUID playersUUID;
    private int runs;
    private final boolean timeout;
    private boolean opened;

    public PlayerInGUITask(Player player, boolean bl) {
        this.player = player;
        this.playersUUID = player.getUniqueId();
        this.runs = 0;
        this.timeout = bl;
    }

    public void run() {
        ++this.runs;
        if (!this.opened) {
            InventoryManager.getInstance().openPINInventory(this.player);
            this.opened = true;
        }
        this.player.addPotionEffect(BLINDNESS_POTION);
        if (this.timeout && (double)this.runs >= PINPrompt.getInstance().getConfig().getDouble("PIN Settings.Entry Time") * 20.0) {
            PINManager.getInstance().handleSavedModes(this.player);
            this.player.kickPlayer(ColorHelper.colorize(Common.getLanguage("Timeout", false)));
            this.cancel();
        }
        if (this.player.getOpenInventory().getTopInventory().equals(InventoryManager.getInstance().getPINInventory())) {
            return;
        }
        PINManager.getInstance().removePlayersEnteredPIN(this.playersUUID);
        if (PINManager.getInstance().isPlayerNeedingPIN(this.playersUUID)) {
            InventoryManager.getInstance().openPINInventory(this.player);
            return;
        }
        if (PINManager.getInstance().isPlayerCreatingPIN(this.playersUUID)) {
            if (this.player.hasPermission("pinprompt.force") && DataManager.getInstance().getPINPlayer(this.playersUUID).getPIN() == null) {
                InventoryManager.getInstance().openPINInventory(this.player);
                return;
            }
            PINManager.getInstance().removePlayerFromCreatingPIN(this.playersUUID);
            PINManager.getInstance().handleSavedModes(this.player);
            Common.tell((CommandSender)this.player, Common.getLanguage("Cancelled PIN", true));
            this.cancel();
            return;
        }
    }
}

