/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.pinprompt.utils;

import dev.hexedhero.pinprompt.utils.VersionHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;

public class ColorHelper {
    private static final List<Pattern> HEX_PATTERNS = Arrays.asList(Pattern.compile("<#([A-Fa-f0-9]){6}>"), Pattern.compile("\\[#([A-Fa-f0-9]){6}\\]"), Pattern.compile("\\{#([A-Fa-f0-9]){6}\\}"), Pattern.compile("\\(#([A-Fa-f0-9]){6}\\)"), Pattern.compile("&#([A-Fa-f0-9]){6}"), Pattern.compile("#([A-Fa-f0-9]){6}"));

    private ColorHelper() {
    }

    public static String colorize(String string) {
        for (Pattern pattern : HEX_PATTERNS) {
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                ChatColor chatColor = ColorHelper.getHexColorOrClosestLegacyColor(ColorHelper.cleanHex(matcher.group()));
                String string2 = string.substring(0, matcher.start());
                String string3 = string.substring(matcher.end());
                string = string2 + chatColor + string3;
                matcher = pattern.matcher(string);
            }
        }
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        return string;
    }

    public static List<String> colorize(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(ColorHelper.colorize(string));
        }
        return arrayList;
    }

    private static ChatColor getHexColorOrClosestLegacyColor(String string) {
        if (VersionHelper.getMajorVersionNumber() >= 16) {
            return ChatColor.of((String)string);
        }
        int n = Integer.MAX_VALUE;
        ChatColor chatColor = ChatColor.WHITE;
        Color color = Color.decode(string);
        for (ChatColorToHexMappings chatColorToHexMappings : ChatColorToHexMappings.values()) {
            int n2;
            int n3;
            int n4 = chatColorToHexMappings.getRed() - color.getRed();
            int n5 = n4 * n4 + (n3 = chatColorToHexMappings.getGreen() - color.getGreen()) * n3 + (n2 = chatColorToHexMappings.getBlue() - color.getBlue()) * n2;
            if (n5 >= n) continue;
            n = n5;
            chatColor = chatColorToHexMappings.getChatColor();
        }
        return chatColor;
    }

    private static String cleanHex(String string) {
        return string.replaceAll("[<>\\[\\]\\{\\}\\(\\)&]", "");
    }

    private static enum ChatColorToHexMappings {
        BLACK(ChatColor.BLACK, 0),
        DARK_BLUE(ChatColor.DARK_BLUE, 170),
        DARK_GREEN(ChatColor.DARK_GREEN, 43520),
        DARK_AQUA(ChatColor.DARK_AQUA, 43690),
        DARK_RED(ChatColor.DARK_RED, 0xAA0000),
        DARK_PURPLE(ChatColor.DARK_PURPLE, 0xAA00AA),
        GOLD(ChatColor.GOLD, 0xFFAA00),
        GRAY(ChatColor.GRAY, 0xAAAAAA),
        DARK_GRAY(ChatColor.DARK_GRAY, 0x555555),
        BLUE(ChatColor.BLUE, 0x5555FF),
        GREEN(ChatColor.GREEN, 0x55FF55),
        AQUA(ChatColor.AQUA, 0x55FFFF),
        RED(ChatColor.RED, 0xFF5555),
        LIGHT_PURPLE(ChatColor.LIGHT_PURPLE, 0xFF55FF),
        YELLOW(ChatColor.YELLOW, 0xFFFF55),
        WHITE(ChatColor.WHITE, 0xFFFFFF);

        private final ChatColor chatColor;
        private final int red;
        private final int green;
        private final int blue;

        private ChatColorToHexMappings(ChatColor chatColor, int n2) {
            this.chatColor = chatColor;
            this.red = n2 >> 16 & 0xFF;
            this.green = n2 >> 8 & 0xFF;
            this.blue = n2 & 0xFF;
        }

        public ChatColor getChatColor() {
            return this.chatColor;
        }

        public int getRed() {
            return this.red;
        }

        public int getGreen() {
            return this.green;
        }

        public int getBlue() {
            return this.blue;
        }
    }
}

