/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit;

import java.nio.file.Path;
import net.skinsrestorer.bukkit.SRBukkitAdapter;
import net.skinsrestorer.bukkit.SRBukkitInit;
import net.skinsrestorer.bukkit.logger.BukkitConsoleImpl;
import net.skinsrestorer.bukkit.update.UpdateDownloaderGithub;
import net.skinsrestorer.bukkit.utils.PluginJarProvider;
import net.skinsrestorer.shadow.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.skinsrestorer.shared.log.JavaLoggerImpl;
import net.skinsrestorer.shared.plugin.SRBootstrapper;
import net.skinsrestorer.shared.plugin.SRServerPlugin;
import net.skinsrestorer.shared.update.DownloaderClassProvider;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SRBukkitBootstrap
extends JavaPlugin {
    private Runnable shutdownHook;

    public void onEnable() {
        Server server = this.getServer();
        Path pluginFile = this.getFile().toPath();
        SRBootstrapper.startPlugin(runnable -> {
            this.shutdownHook = runnable;
        }, injector -> {
            injector.register(JavaPlugin.class, this);
            injector.register(Server.class, server);
            injector.register(BukkitAudiences.class, BukkitAudiences.create((Plugin)this));
            injector.register(PluginJarProvider.class, () -> pluginFile);
            injector.register(DownloaderClassProvider.class, () -> UpdateDownloaderGithub.class);
        }, new JavaLoggerImpl(new BukkitConsoleImpl(server.getConsoleSender()), server.getLogger()), true, SRBukkitAdapter.class, SRServerPlugin.class, this.getDescription().getVersion(), this.getDataFolder().toPath(), SRBukkitInit.class);
    }

    public void onDisable() {
        this.shutdownHook.run();
    }

    public Runnable getShutdownHook() {
        return this.shutdownHook;
    }
}

