/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.skinsrestorer.api.SkinsRestorerProvider;
import net.skinsrestorer.api.semver.SemanticVersion;
import net.skinsrestorer.bukkit.SRBukkitAdapter;
import net.skinsrestorer.bukkit.SkinApplierBukkit;
import net.skinsrestorer.bukkit.command.SRBukkitCommand;
import net.skinsrestorer.bukkit.command.SRHelpTopic;
import net.skinsrestorer.bukkit.hooks.SRPlaceholderAPIExpansion;
import net.skinsrestorer.bukkit.listener.InventoryListener;
import net.skinsrestorer.bukkit.listener.PlayerJoin;
import net.skinsrestorer.bukkit.listener.PlayerResourcePackStatus;
import net.skinsrestorer.bukkit.listener.ServerMessageListener;
import net.skinsrestorer.bukkit.paper.PaperPlayerJoinEvent;
import net.skinsrestorer.bukkit.utils.BukkitReflection;
import net.skinsrestorer.bukkit.utils.NMSVersion;
import net.skinsrestorer.bukkit.utils.NoMappingException;
import net.skinsrestorer.bukkit.wrapper.WrapperBukkit;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.config.AdvancedConfig;
import net.skinsrestorer.shared.exception.InitializeException;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.plugin.SRServerPlatformInit;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.subjects.permissions.PermissionGroup;
import net.skinsrestorer.shared.subjects.permissions.PermissionRegistry;
import net.skinsrestorer.shared.utils.ComponentHelper;
import net.skinsrestorer.shared.utils.ReflectionUtil;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class SRBukkitInit
implements SRServerPlatformInit {
    private final SRPlugin plugin;
    private final SRBukkitAdapter adapter;
    private final Injector injector;
    private final SRLogger logger;
    private final Server server;
    private final WrapperBukkit wrapper;
    private final SkinsRestorerLocale locale;
    private final SettingsManager settingsManager;

    @Override
    public void initSkinApplier() throws InitializeException {
        SkinApplierBukkit skinApplierBukkit;
        try {
            skinApplierBukkit = this.injector.getSingleton(SkinApplierBukkit.class);
            if (SRPlugin.isUnitTest()) {
                skinApplierBukkit.setRefresh(player -> {});
            } else {
                skinApplierBukkit.setRefresh(skinApplierBukkit.detectRefresh(this.server));
            }
        }
        catch (NoMappingException e) {
            this.logger.severe("Your Minecraft version is not supported by this version of SkinsRestorer! Is there a newer version available? If not, join our discord server!", e);
            throw e;
        }
        catch (InitializeException e) {
            this.logger.severe(ChatColor.RED + ChatColor.UNDERLINE.toString() + "Could not initialize SkinApplier! Please report this on our discord server!");
            throw e;
        }
        this.plugin.registerSkinApplier(skinApplierBukkit, Player.class, this.wrapper::player);
        this.logger.info(ChatColor.GREEN + "Detected Minecraft " + ChatColor.YELLOW + BukkitReflection.SERVER_VERSION_STRING + ChatColor.GREEN + ", using " + ChatColor.YELLOW + skinApplierBukkit.getRefresh().getClass().getSimpleName() + ChatColor.GREEN + ".");
        if (!NMSVersion.SERVER_VERSION.isNewerThan(new SemanticVersion(1, 7, 10))) {
            this.logger.warning(ChatColor.YELLOW + "Although SkinsRestorer allows using this ancient version, we will not provide full support for it. This version of Minecraft does not allow using all of SkinsRestorers features due to client side restrictions. Please be aware things WILL BREAK and not work!");
        }
    }

    @Override
    public void initLoginProfileListener() {
        if (PaperPlayerJoinEvent.isAvailable() && this.settingsManager.getProperty(AdvancedConfig.ENABLE_PAPER_JOIN_LISTENER).booleanValue()) {
            this.logger.info("Using paper join listener!");
            this.server.getPluginManager().registerEvents((Listener)this.injector.newInstance(PaperPlayerJoinEvent.class), (Plugin)this.adapter.getPluginInstance());
        } else {
            this.server.getPluginManager().registerEvents((Listener)this.injector.newInstance(PlayerJoin.class), (Plugin)this.adapter.getPluginInstance());
            if (ReflectionUtil.classExists("org.bukkit.event.player.PlayerResourcePackStatusEvent")) {
                this.server.getPluginManager().registerEvents((Listener)this.injector.newInstance(PlayerResourcePackStatus.class), (Plugin)this.adapter.getPluginInstance());
            }
        }
    }

    @Override
    public void prePlatformInit() {
        this.server.getHelpMap().registerHelpTopicFactory(SRBukkitCommand.class, command -> new SRHelpTopic((SRBukkitCommand)command, this.wrapper, this.locale));
        this.plugin.getShutdownHooks().add(() -> this.adapter.getAdventure().close());
    }

    @Override
    public void checkPluginSupport() {
        this.checkViaVersion();
        this.checkMundoSK();
    }

    private void checkViaVersion() {
        if (!this.adapter.isPluginEnabled("ViaVersion")) {
            return;
        }
        if (ReflectionUtil.classExists("com.viaversion.viaversion.api.Via")) {
            return;
        }
        this.adapter.runRepeatAsync(() -> this.logger.severe("Outdated ViaVersion found! Please update to at least ViaVersion 4.0.0 for SkinsRestorer to work again!"), 2, 60, TimeUnit.SECONDS);
    }

    private void checkMundoSK() {
        if (!this.adapter.isPluginEnabled("MundoSK")) {
            return;
        }
        Path pluginsFolder = this.plugin.getDataFolder().getParent();
        if (pluginsFolder == null) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(pluginsFolder.resolve("MundoSK").resolve("config.yml"));){
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
            if (config.getBoolean("enable_custom_skin_and_tablist")) {
                this.logger.warning(ChatColor.DARK_RED + "----------------------------------------------");
                this.logger.warning(ChatColor.DARK_RED + "             [CRITICAL WARNING]");
                this.logger.warning(ChatColor.RED + "We have detected MundoSK on your server with " + ChatColor.YELLOW + "'enable_custom_skin_and_tablist: " + ChatColor.DARK_RED + ChatColor.UNDERLINE + "true" + ChatColor.YELLOW + "' " + ChatColor.RED + ".");
                this.logger.warning(ChatColor.RED + "That setting is located in \u00a7e/plugins/MundoSK/config.yml");
                this.logger.warning(ChatColor.RED + "You have to disable ('false') it to get SkinsRestorer to work!");
                this.logger.warning(ChatColor.DARK_RED + "----------------------------------------------");
            }
        }
        catch (IOException e) {
            this.logger.warning("Could not read MundoSK config.yml to check for 'enable_custom_skin_and_tablist'!", e);
        }
    }

    @Override
    public void initPermissions() {
        for (PermissionRegistry permissionRegistry : PermissionRegistry.values()) {
            String permissionString = permissionRegistry.getPermission().getPermissionString();
            String description = ComponentHelper.convertJsonToLegacy(this.locale.getMessage(this.locale.getDefaultForeign(), permissionRegistry.getDescription()));
            this.addPermission(new Permission(permissionString, description));
        }
        for (Enum enum_ : PermissionGroup.values()) {
            String description = ComponentHelper.convertJsonToLegacy(this.locale.getMessage(this.locale.getDefaultForeign(), ((PermissionGroup)enum_).getDescription()));
            HashMap<String, Boolean> children = new HashMap<String, Boolean>();
            this.mergePermissions((PermissionGroup)enum_, children);
            PermissionDefault permissionDefault = enum_ == PermissionGroup.PLAYER ? PermissionDefault.TRUE : PermissionDefault.OP;
            this.addPermission(new Permission(((PermissionGroup)enum_).getBasePermission().getPermissionString(), description, permissionDefault, children));
            this.addPermission(new Permission(((PermissionGroup)enum_).getWildcard().getPermissionString(), description, permissionDefault, children));
        }
    }

    private void addPermission(Permission permission) {
        SimplePluginManager pluginManager = (SimplePluginManager)this.server.getPluginManager();
        if (pluginManager.getPermission(permission.getName()) != null) {
            return;
        }
        pluginManager.addPermission(permission);
    }

    private void mergePermissions(PermissionGroup group, Map<String, Boolean> data) {
        for (PermissionRegistry permissionRegistry : group.getPermissions()) {
            data.put(permissionRegistry.getPermission().getPermissionString(), true);
        }
        for (Enum enum_ : group.getParents()) {
            this.mergePermissions((PermissionGroup)enum_, data);
        }
    }

    @Override
    public void initGUIListener() {
        this.server.getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)this.adapter.getPluginInstance());
    }

    @Override
    public void initMessageChannel() {
        this.server.getMessenger().registerOutgoingPluginChannel((Plugin)this.adapter.getPluginInstance(), "sr:messagechannel");
        this.server.getMessenger().registerIncomingPluginChannel((Plugin)this.adapter.getPluginInstance(), "sr:messagechannel", (PluginMessageListener)this.injector.getSingleton(ServerMessageListener.class));
    }

    @Override
    public void postAPIInitHook() {
        if (this.adapter.isPluginEnabled("PlaceholderAPI")) {
            new SRPlaceholderAPIExpansion(SkinsRestorerProvider.get(), this.adapter.getPluginInstance().getDescription()).register();
            this.logger.info("PlaceholderAPI expansion registered!");
        }
    }

    @Inject
    public SRBukkitInit(SRPlugin plugin, SRBukkitAdapter adapter, Injector injector, SRLogger logger, Server server, WrapperBukkit wrapper, SkinsRestorerLocale locale, SettingsManager settingsManager) {
        this.plugin = plugin;
        this.adapter = adapter;
        this.injector = injector;
        this.logger = logger;
        this.server = server;
        this.wrapper = wrapper;
        this.locale = locale;
        this.settingsManager = settingsManager;
    }
}

