/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.command;

import java.util.Arrays;
import java.util.List;
import net.skinsrestorer.bukkit.wrapper.WrapperBukkit;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shared.commands.library.CommandExecutor;
import net.skinsrestorer.shared.commands.library.CommandUtils;
import net.skinsrestorer.shared.commands.library.SRCommandMeta;
import net.skinsrestorer.shared.commands.library.SRRegisterPayload;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;

public class SRBukkitCommand
extends Command
implements PluginIdentifiableCommand {
    private final Plugin plugin;
    private final CommandExecutor<SRCommandSender> executor;
    private final WrapperBukkit wrapper;
    private final SRCommandMeta<SRCommandSender> meta;

    public SRBukkitCommand(SRRegisterPayload<SRCommandSender> payload, Plugin plugin, WrapperBukkit wrapper) {
        super(payload.getMeta().getRootName(), "", "", Arrays.asList(payload.getMeta().getAliases()));
        this.plugin = plugin;
        this.wrapper = wrapper;
        this.executor = payload.getExecutor();
        this.meta = payload.getMeta();
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        this.executor.execute(this.wrapper.commandSender(sender), CommandUtils.joinCommand(commandLabel, args));
        return true;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
        return this.executor.tabComplete(this.wrapper.commandSender(sender), CommandUtils.joinCommand(alias, args)).join();
    }

    public boolean testPermissionSilent(@NotNull CommandSender target) {
        return this.executor.hasPermission(this.wrapper.commandSender(target));
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public CommandExecutor<SRCommandSender> getExecutor() {
        return this.executor;
    }

    public SRCommandMeta<SRCommandSender> getMeta() {
        return this.meta;
    }
}

