/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.folia;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.skinsrestorer.bukkit.utils.SchedulerProvider;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class FoliaSchedulerProvider
implements SchedulerProvider {
    @Override
    public void runAsync(Server server, Plugin plugin, Runnable runnable) {
        server.getAsyncScheduler().runNow(plugin, this.getCancellingTaskConsumer(plugin, runnable));
    }

    @Override
    @Deprecated
    public void runSync(Server server, Plugin plugin, Runnable runnable) {
        this.runAsync(server, plugin, runnable);
    }

    @Override
    public void runSyncToEntity(Server server, Plugin plugin, Entity entity, Runnable runnable) {
        entity.getScheduler().run(plugin, this.getCancellingTaskConsumer(plugin, runnable), null);
    }

    @Override
    public void runRepeatAsync(Server server, Plugin plugin, Runnable runnable, int delay, int interval, TimeUnit timeUnit) {
        server.getAsyncScheduler().runAtFixedRate(plugin, this.getCancellingTaskConsumer(plugin, runnable), (long)delay, (long)interval, timeUnit);
    }

    @Override
    public void unregisterTasks(Server server, Plugin plugin) {
        server.getAsyncScheduler().cancelTasks(plugin);
    }

    private Consumer<ScheduledTask> getCancellingTaskConsumer(Plugin plugin, Runnable runnable) {
        return scheduledTask -> {
            if (plugin.isEnabled()) {
                runnable.run();
            } else {
                scheduledTask.cancel();
            }
        };
    }

    @Override
    public boolean isAvailable() {
        try {
            Server.class.getMethod("getAsyncScheduler", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

