/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.gui;

import java.util.Map;
import java.util.function.Consumer;
import net.skinsrestorer.bukkit.gui.SkinsGUIHolder;
import net.skinsrestorer.bukkit.wrapper.WrapperBukkit;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.skinsrestorer.shadow.xseries.SkullUtils;
import net.skinsrestorer.shadow.xseries.XMaterial;
import net.skinsrestorer.shared.gui.GUIManager;
import net.skinsrestorer.shared.listeners.event.ClickEventInfo;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.subjects.SRForeign;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.utils.ComponentHelper;
import net.skinsrestorer.shared.utils.FluentList;
import org.bukkit.Server;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkinsGUI
implements GUIManager<Inventory> {
    private final SkinsRestorerLocale locale;
    private final SRLogger logger;
    private final Server server;
    private final WrapperBukkit wrapper;

    private static ItemStack createSkull(SRLogger log, SkinsRestorerLocale locale, SRForeign player, String name, String property) {
        ItemStack itemStack = XMaterial.PLAYER_HEAD.parseItem();
        if (itemStack == null) {
            throw new IllegalStateException("Could not create skull for " + name + "!");
        }
        SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
        if (skullMeta == null) {
            throw new IllegalStateException("Could not create skull for " + name + "!");
        }
        skullMeta.setDisplayName(name);
        skullMeta.setLore(FluentList.of(ComponentHelper.convertJsonToLegacy(locale.getMessage(player, Message.SKINSMENU_SELECT_SKIN))));
        try {
            SkullUtils.applySkin((ItemMeta)skullMeta, property);
        }
        catch (AssertionError e) {
            log.warning(String.format("Could not add '%s' to SkinsGUI, skin might be corrupted or invalid!", name));
            ((Throwable)((Object)e)).printStackTrace();
        }
        itemStack.setItemMeta((ItemMeta)skullMeta);
        return itemStack;
    }

    private static ItemStack createGlass(GlassType type, SRForeign player, SkinsRestorerLocale locale) {
        ItemStack itemStack = type.getMaterial().parseItem();
        if (itemStack == null) {
            throw new IllegalStateException("Could not create glass for " + type.name() + "!");
        }
        String text = type.getMessage() == null ? " " : ComponentHelper.convertJsonToLegacy(locale.getMessage(player, type.getMessage()));
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            throw new IllegalStateException("Could not create glass for " + type.name() + "!");
        }
        itemMeta.setDisplayName(text);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    public Inventory createGUI(Consumer<ClickEventInfo> callback, SRForeign player, int page, Map<String, String> skinsList) {
        SkinsGUIHolder instance = new SkinsGUIHolder(page, callback, this.wrapper);
        Inventory inventory = this.server.createInventory((InventoryHolder)instance, 54, ComponentHelper.convertJsonToLegacy(this.locale.getMessage(player, Message.SKINSMENU_TITLE_NEW, Placeholder.unparsed("page_number", String.valueOf(page + 1)))));
        instance.setInventory(inventory);
        ItemStack none = SkinsGUI.createGlass(GlassType.NONE, player, this.locale);
        ItemStack delete = SkinsGUI.createGlass(GlassType.DELETE, player, this.locale);
        ItemStack prev = SkinsGUI.createGlass(GlassType.PREV, player, this.locale);
        ItemStack next = SkinsGUI.createGlass(GlassType.NEXT, player, this.locale);
        int skinCount = 0;
        for (Map.Entry<String, String> entry : skinsList.entrySet()) {
            if (skinCount >= 36) {
                this.logger.warning("SkinsGUI: Skin count is more than 36, skipping...");
                break;
            }
            inventory.addItem(new ItemStack[]{SkinsGUI.createSkull(this.logger, this.locale, player, entry.getKey(), entry.getValue())});
            ++skinCount;
        }
        inventory.setItem(36, none);
        inventory.setItem(37, none);
        inventory.setItem(38, none);
        inventory.setItem(39, none);
        inventory.setItem(40, none);
        inventory.setItem(41, none);
        inventory.setItem(42, none);
        inventory.setItem(43, none);
        inventory.setItem(44, none);
        if (page > 0) {
            inventory.setItem(45, prev);
            inventory.setItem(46, prev);
            inventory.setItem(47, prev);
        } else {
            inventory.setItem(45, none);
            inventory.setItem(46, none);
            inventory.setItem(47, none);
        }
        inventory.setItem(48, delete);
        inventory.setItem(49, delete);
        inventory.setItem(50, delete);
        if (page < 999 && inventory.firstEmpty() > 50) {
            inventory.setItem(51, next);
            inventory.setItem(52, next);
            inventory.setItem(53, next);
        } else {
            inventory.setItem(51, none);
            inventory.setItem(52, none);
            inventory.setItem(53, none);
        }
        return inventory;
    }

    @Inject
    public SkinsGUI(SkinsRestorerLocale locale, SRLogger logger, Server server, WrapperBukkit wrapper) {
        this.locale = locale;
        this.logger = logger;
        this.server = server;
        this.wrapper = wrapper;
    }

    private static enum GlassType {
        NONE(XMaterial.WHITE_STAINED_GLASS_PANE, null),
        PREV(XMaterial.YELLOW_STAINED_GLASS_PANE, Message.SKINSMENU_PREVIOUS_PAGE),
        NEXT(XMaterial.GREEN_STAINED_GLASS_PANE, Message.SKINSMENU_NEXT_PAGE),
        DELETE(XMaterial.RED_STAINED_GLASS_PANE, Message.SKINSMENU_CLEAR_SKIN);

        private final XMaterial material;
        private final Message message;

        public XMaterial getMaterial() {
            return this.material;
        }

        public Message getMessage() {
            return this.message;
        }

        private GlassType(XMaterial material, Message message) {
            this.material = material;
            this.message = message;
        }
    }
}

