/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.hooks;

import java.util.Locale;
import java.util.Optional;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.skinsrestorer.api.PropertyUtils;
import net.skinsrestorer.api.SkinsRestorer;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.storage.PlayerStorage;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.PluginDescriptionFile;

public class SRPlaceholderAPIExpansion
extends PlaceholderExpansion {
    private static final String STEVE_URL = "https://textures.minecraft.net/texture/6d3b06c38504ffc0229b9492147c69fcf59fd2ed7885f78502152f77b4d50de1";
    private static final String ALEX_URL = "https://textures.minecraft.net/texture/fb9ab3483f8106ecc9e76bd47c71312b0f16a58784d606864f3b3e9cb1fd7b6c";
    private static final String ERROR_MESSAGE = "Error";
    private final SkinsRestorer api;
    private final PluginDescriptionFile description;

    @NotNull
    public String getIdentifier() {
        return "skinsrestorer";
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", this.description.getAuthors());
    }

    @NotNull
    public String getVersion() {
        return this.description.getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String params) {
        params = params.toLowerCase(Locale.ROOT);
        PlayerStorage storage = this.api.getPlayerStorage();
        if (params.startsWith("skin_name")) {
            if (offlinePlayer == null) {
                return ERROR_MESSAGE;
            }
            Optional<SkinIdentifier> skin = storage.getSkinIdOfPlayer(offlinePlayer.getUniqueId());
            if (skin.isPresent()) {
                return skin.get().getIdentifier();
            }
            if (params.startsWith("skin_name_")) {
                String subString = params.substring("skin_name_".length());
                if (subString.equalsIgnoreCase("or_empty")) {
                    return "";
                }
                if (subString.equalsIgnoreCase("or_player_name")) {
                    return offlinePlayer.getName();
                }
            }
            return ERROR_MESSAGE;
        }
        if (params.startsWith("texture_url")) {
            if (offlinePlayer == null) {
                return ERROR_MESSAGE;
            }
            try {
                Optional<SkinProperty> skin = storage.getSkinForPlayer(offlinePlayer.getUniqueId(), offlinePlayer.getName());
                if (skin.isPresent()) {
                    return this.extractUrl(skin.get());
                }
                if (params.startsWith("texture_url_")) {
                    String subString = params.substring("texture_url_".length());
                    if (subString.equalsIgnoreCase("or_empty")) {
                        return "";
                    }
                    if (subString.equalsIgnoreCase("or_steve")) {
                        return STEVE_URL;
                    }
                    if (subString.equalsIgnoreCase("or_alex")) {
                        return ALEX_URL;
                    }
                }
            }
            catch (DataRequestException e) {
                e.printStackTrace();
            }
            return ERROR_MESSAGE;
        }
        if (params.startsWith("texture_id")) {
            if (offlinePlayer == null) {
                return ERROR_MESSAGE;
            }
            try {
                Optional<SkinProperty> skin = storage.getSkinForPlayer(offlinePlayer.getUniqueId(), offlinePlayer.getName());
                if (skin.isPresent()) {
                    return this.extractUrlStripped(skin.get());
                }
                if (params.startsWith("texture_id_")) {
                    String subString = params.substring("texture_id_".length());
                    if (subString.equalsIgnoreCase("or_empty")) {
                        return "";
                    }
                    if (subString.equalsIgnoreCase("or_steve")) {
                        return STEVE_URL;
                    }
                    if (subString.equalsIgnoreCase("or_alex")) {
                        return ALEX_URL;
                    }
                }
            }
            catch (DataRequestException e) {
                e.printStackTrace();
            }
            return ERROR_MESSAGE;
        }
        return null;
    }

    private String extractUrl(SkinProperty property) {
        return PropertyUtils.getSkinTextureUrl(property);
    }

    private String extractUrlStripped(SkinProperty property) {
        return PropertyUtils.getSkinTextureUrlStripped(property);
    }

    public SRPlaceholderAPIExpansion(SkinsRestorer api, PluginDescriptionFile description) {
        this.api = api;
        this.description = description;
    }
}

