/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.paper;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import java.util.Arrays;
import java.util.function.Function;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.commands.library.SRRegisterPayload;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PaperTabCompleteEvent
implements Listener {
    private final SRRegisterPayload<SRCommandSender> payload;
    private final Function<CommandSender, SRCommandSender> senderMapper;

    @EventHandler(ignoreCancelled=true)
    public void onAsyncTabComplete(AsyncTabCompleteEvent event) {
        String[] args;
        if (!event.isCommand() || event.isHandled() || event.getBuffer().isEmpty()) {
            return;
        }
        String buffer = event.getBuffer();
        if (buffer.charAt(0) == '/') {
            buffer = buffer.substring(1);
        }
        if ((args = buffer.split(" ")).length == 0) {
            return;
        }
        String command = args[0];
        if (!command.equals(this.payload.getMeta().getRootName()) && !Arrays.asList(this.payload.getMeta().getAliases()).contains(command)) {
            return;
        }
        event.setHandled(true);
        event.setCompletions(this.payload.getExecutor().tabComplete(this.senderMapper.apply(event.getSender()), buffer).join());
    }

    @Inject
    public PaperTabCompleteEvent(SRRegisterPayload<SRCommandSender> payload, Function<CommandSender, SRCommandSender> senderMapper) {
        this.payload = payload;
        this.senderMapper = senderMapper;
    }
}

