/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.skinrefresher;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.skinsrestorer.bukkit.SRBukkitAdapter;
import net.skinsrestorer.bukkit.skinrefresher.ViaWorkaround;
import net.skinsrestorer.bukkit.utils.BukkitReflection;
import net.skinsrestorer.bukkit.utils.OPRefreshUtil;
import net.skinsrestorer.mappings.shared.ViaPacketData;
import net.skinsrestorer.shared.exception.InitializeException;
import net.skinsrestorer.shared.utils.FluentList;
import net.skinsrestorer.shared.utils.ReflectionUtil;
import net.skinsrestorer.shared.utils.SRHelpers;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public final class SpigotSkinRefresher
implements Consumer<Player> {
    private final SRBukkitAdapter adapter;
    private final boolean viaWorkaround;
    private final Class<?> playOutRespawn;
    private final Class<?> playOutPlayerInfo;
    private final Class<?> playOutPosition;
    private final Class<?> packet;
    private final Class<?> playOutHeldItemSlot;
    private Enum<?> removePlayerEnum;
    private Enum<?> addPlayerEnum;

    public SpigotSkinRefresher(SRBukkitAdapter adapter, boolean viaWorkaround) throws InitializeException {
        this.adapter = adapter;
        this.viaWorkaround = viaWorkaround;
        try {
            this.packet = BukkitReflection.getNMSClass("Packet", "net.minecraft.network.protocol.Packet");
            this.playOutHeldItemSlot = BukkitReflection.getNMSClass("PacketPlayOutHeldItemSlot", "net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot");
            this.playOutPosition = BukkitReflection.getNMSClass("PacketPlayOutPosition", "net.minecraft.network.protocol.game.PacketPlayOutPosition");
            this.playOutPlayerInfo = BukkitReflection.getNMSClass("PacketPlayOutPlayerInfo", "net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo");
            this.playOutRespawn = BukkitReflection.getNMSClass("PacketPlayOutRespawn", "net.minecraft.network.protocol.game.PacketPlayOutRespawn");
            try {
                this.removePlayerEnum = ReflectionUtil.getEnum(this.playOutPlayerInfo, "EnumPlayerInfoAction", "REMOVE_PLAYER");
                this.addPlayerEnum = ReflectionUtil.getEnum(this.playOutPlayerInfo, "EnumPlayerInfoAction", "ADD_PLAYER");
            }
            catch (ReflectiveOperationException e1) {
                try {
                    Class<?> enumPlayerInfoActionClass = Class.forName("net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo$EnumPlayerInfoAction");
                    this.removePlayerEnum = ReflectionUtil.getEnum(enumPlayerInfoActionClass, 4);
                    this.addPlayerEnum = ReflectionUtil.getEnum(enumPlayerInfoActionClass, 0);
                }
                catch (ReflectiveOperationException e2) {
                    try {
                        this.removePlayerEnum = ReflectionUtil.getEnum(this.playOutPlayerInfo, "Action", "REMOVE_PLAYER");
                        this.addPlayerEnum = ReflectionUtil.getEnum(this.playOutPlayerInfo, "Action", "ADD_PLAYER");
                    }
                    catch (ReflectiveOperationException e3) {
                        try {
                            Class<?> enumPlayerInfoAction = BukkitReflection.getNMSClass("EnumPlayerInfoAction", null);
                            this.removePlayerEnum = ReflectionUtil.getEnum(enumPlayerInfoAction, "REMOVE_PLAYER");
                            this.addPlayerEnum = ReflectionUtil.getEnum(enumPlayerInfoAction, "ADD_PLAYER");
                        }
                        catch (ReflectiveOperationException reflectiveOperationException) {}
                    }
                }
            }
        }
        catch (ReflectiveOperationException e) {
            throw new InitializeException(e);
        }
    }

    private void sendPacket(Object playerConnection, Object packet) throws ReflectiveOperationException {
        ReflectionUtil.invokeMethod(playerConnection.getClass(), playerConnection, "sendPacket", new Class[]{this.packet}, packet);
    }

    @Override
    public void accept(Player player) {
        try {
            Object pos;
            Object respawn;
            Object worldType;
            Object worldData;
            Object difficulty;
            Object addPlayer;
            Object removePlayer;
            Object entityPlayer = BukkitReflection.getHandle(player, Object.class);
            try {
                removePlayer = ReflectionUtil.invokeConstructor(this.playOutPlayerInfo, this.removePlayerEnum, FluentList.of(entityPlayer));
                addPlayer = ReflectionUtil.invokeConstructor(this.playOutPlayerInfo, this.addPlayerEnum, FluentList.of(entityPlayer));
            }
            catch (ReflectiveOperationException e) {
                int ping = ReflectionUtil.getObject(entityPlayer, "ping", Integer.TYPE);
                removePlayer = ReflectionUtil.invokeConstructor(this.playOutPlayerInfo, player.getPlayerListName(), false, 9999);
                addPlayer = ReflectionUtil.invokeConstructor(this.playOutPlayerInfo, player.getPlayerListName(), true, ping);
            }
            Object world = ReflectionUtil.invokeMethod(entityPlayer, "getWorld");
            try {
                difficulty = ReflectionUtil.invokeMethod(world, "getDifficulty");
            }
            catch (ReflectiveOperationException e) {
                difficulty = ReflectionUtil.getObject(world, "difficulty", Object.class);
            }
            try {
                worldData = ReflectionUtil.invokeMethod(world, "getWorldData");
            }
            catch (ReflectiveOperationException ignored) {
                worldData = ReflectionUtil.getObject(world, "worldData", Object.class);
            }
            try {
                worldType = ReflectionUtil.invokeMethod(worldData, "getType");
            }
            catch (ReflectiveOperationException ignored) {
                worldType = ReflectionUtil.invokeMethod(worldData, "getGameType");
            }
            Object playerIntManager = ReflectionUtil.getFieldByType(entityPlayer, "PlayerInteractManager");
            Enum enumGamemode = (Enum)ReflectionUtil.invokeMethod(playerIntManager, "getGameMode");
            int gamemodeId = player.getGameMode().getValue();
            int dimension = player.getWorld().getEnvironment().getId();
            try {
                respawn = ReflectionUtil.invokeConstructor(this.playOutRespawn, dimension, difficulty, worldType, enumGamemode);
            }
            catch (Exception ignored) {
                Object worldObject = ReflectionUtil.getFieldByType(entityPlayer, "World");
                Object dimensionManager = this.getDimensionManager(worldObject, dimension);
                try {
                    respawn = ReflectionUtil.invokeConstructor(this.playOutRespawn, dimensionManager, difficulty, worldType, enumGamemode);
                }
                catch (ReflectiveOperationException ignored2) {
                    try {
                        respawn = ReflectionUtil.invokeConstructor(this.playOutRespawn, dimensionManager, worldType, enumGamemode);
                    }
                    catch (ReflectiveOperationException ignored3) {
                        long seedEncrypted = SRHelpers.hashSha256String(String.valueOf(player.getWorld().getSeed()));
                        try {
                            respawn = ReflectionUtil.invokeConstructor(this.playOutRespawn, dimensionManager, seedEncrypted, worldType, enumGamemode);
                        }
                        catch (ReflectiveOperationException ignored5) {
                            Object dimensionKey = ReflectionUtil.invokeMethod(worldObject, "getDimensionKey");
                            boolean debug = (Boolean)ReflectionUtil.invokeMethod(worldObject, "isDebugWorld");
                            boolean flat = (Boolean)ReflectionUtil.invokeMethod(worldObject, "isFlatWorld");
                            List<Object> gameModeList = ReflectionUtil.getFieldByTypeList(playerIntManager, "EnumGamemode");
                            Enum enumGamemodePrevious = (Enum)this.getFromListExcluded(gameModeList, enumGamemode);
                            try {
                                Object typeKey = ReflectionUtil.invokeMethod(worldObject, "getTypeKey");
                                respawn = ReflectionUtil.invokeConstructor(this.playOutRespawn, typeKey, dimensionKey, seedEncrypted, enumGamemode, enumGamemodePrevious, debug, flat, true);
                            }
                            catch (ReflectiveOperationException ignored6) {
                                respawn = ReflectionUtil.invokeConstructor(this.playOutRespawn, dimensionManager, dimensionKey, seedEncrypted, enumGamemode, enumGamemodePrevious, debug, flat, true);
                            }
                        }
                    }
                }
            }
            Location l = player.getLocation();
            try {
                pos = ReflectionUtil.invokeConstructor(this.playOutPosition, l.getX(), l.getY(), l.getZ(), Float.valueOf(l.getYaw()), Float.valueOf(l.getPitch()), new HashSet(), 0, false);
            }
            catch (ReflectiveOperationException e1) {
                try {
                    pos = ReflectionUtil.invokeConstructor(this.playOutPosition, l.getX(), l.getY(), l.getZ(), Float.valueOf(l.getYaw()), Float.valueOf(l.getPitch()), new HashSet(), 0);
                }
                catch (ReflectiveOperationException e2) {
                    try {
                        pos = ReflectionUtil.invokeConstructor(this.playOutPosition, l.getX(), l.getY(), l.getZ(), Float.valueOf(l.getYaw()), Float.valueOf(l.getPitch()), new HashSet());
                    }
                    catch (ReflectiveOperationException e3) {
                        pos = ReflectionUtil.invokeConstructor(this.playOutPosition, l.getX(), l.getY(), l.getZ(), Float.valueOf(l.getYaw()), Float.valueOf(l.getPitch()), false);
                    }
                }
            }
            Object slot = ReflectionUtil.invokeConstructor(this.playOutHeldItemSlot, player.getInventory().getHeldItemSlot());
            Object playerCon = ReflectionUtil.getFieldByType(entityPlayer, "PlayerConnection");
            this.sendPacket(playerCon, removePlayer);
            this.sendPacket(playerCon, addPlayer);
            boolean sendRespawnPacketDirectly = true;
            if (this.viaWorkaround) {
                try {
                    Object worldObject = ReflectionUtil.getFieldByType(entityPlayer, "World");
                    boolean flat = (Boolean)ReflectionUtil.invokeMethod(worldObject, "isFlatWorld");
                    sendRespawnPacketDirectly = ViaWorkaround.sendCustomPacketVia(new ViaPacketData(player, dimension, SRHelpers.hashSha256String(String.valueOf(player.getWorld().getSeed())), Integer.valueOf(gamemodeId).shortValue(), flat));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (sendRespawnPacketDirectly) {
                this.sendPacket(playerCon, respawn);
            }
            ReflectionUtil.invokeMethod(entityPlayer, "updateAbilities");
            this.sendPacket(playerCon, pos);
            this.sendPacket(playerCon, slot);
            ReflectionUtil.invokeMethod(player, "updateScaledHealth");
            player.updateInventory();
            ReflectionUtil.invokeMethod(entityPlayer, "triggerHealthUpdate");
            OPRefreshUtil.refreshOP(player, this.adapter);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    private Object getFromListExcluded(List<Object> list, Object ... excluded) {
        for (Object obj : list) {
            if (obj == excluded) continue;
            return obj;
        }
        return null;
    }

    private Object getDimensionManager(Object worldObject, int dimension) throws ReflectiveOperationException {
        try {
            return ReflectionUtil.getFieldByType(worldObject, "DimensionManager");
        }
        catch (ReflectiveOperationException e) {
            try {
                Class<?> dimensionManagerClass = BukkitReflection.getNMSClass("DimensionManager", "net.minecraft.world.level.dimension.DimensionManager");
                for (Method m : dimensionManagerClass.getDeclaredMethods()) {
                    if (m.getReturnType() != dimensionManagerClass || m.getParameterCount() != 1 || m.getParameterTypes()[0] != Integer.TYPE) continue;
                    m.setAccessible(true);
                    return m.invoke(null, dimension);
                }
            }
            catch (ReflectiveOperationException e2) {
                e2.printStackTrace();
            }
            throw new ReflectiveOperationException("Could not get DimensionManager from " + worldObject.getClass().getSimpleName());
        }
    }
}

