/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.update;

import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.net.ssl.HttpsURLConnection;
import net.skinsrestorer.bukkit.utils.PluginJarProvider;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.exception.UpdateException;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.update.UpdateDownloader;
import org.bukkit.Server;

public class UpdateDownloaderGithub
implements UpdateDownloader {
    private final SRPlugin plugin;
    private final SRLogger logger;
    private final Server server;
    private final PluginJarProvider jarProvider;

    private void download(String downloadUrl, Path targetFile) throws UpdateException {
        try {
            HttpsURLConnection connection = (HttpsURLConnection)new URL(downloadUrl).openConnection();
            connection.setRequestProperty("User-Agent", this.plugin.getUserAgent());
            if (connection.getResponseCode() != 200) {
                throw new UpdateException("Download returned status code " + connection.getResponseCode());
            }
            Path tempFile = Files.createTempFile("SkinsRestorer-", ".jar", new FileAttribute[0]);
            try (ReadableByteChannel input = Channels.newChannel(connection.getInputStream());
                 FileChannel output = FileChannel.open(tempFile, StandardOpenOption.WRITE);){
                output.transferFrom(input, 0L, Long.MAX_VALUE);
                output.force(true);
            }
            Files.move(tempFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UpdateException("Download failed", e);
        }
    }

    @Override
    public boolean downloadUpdate(String downloadUrl) {
        Path pluginFile = (Path)this.jarProvider.get();
        Path updateFolder = this.server.getUpdateFolderFile().toPath();
        try {
            Files.createDirectories(updateFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.logger.warning("[GitHubUpdate] Could not create update folder", e);
            return false;
        }
        Path updateFile = updateFolder.resolve(pluginFile.getFileName());
        this.logger.info("[GitHubUpdate] Downloading update...");
        try {
            long start = System.currentTimeMillis();
            this.download(downloadUrl, updateFile);
            this.logger.info(String.format("[GitHubUpdate] Downloaded update in %dms", System.currentTimeMillis() - start));
            this.logger.info(String.format("[GitHubUpdate] Update saved as %s", updateFile.getFileName()));
            this.logger.info("[GitHubUpdate] The update will be loaded on the next server restart");
        }
        catch (UpdateException e) {
            this.logger.warning("[GitHubUpdate] Could not download update", e);
            return false;
        }
        return true;
    }

    @Inject
    public UpdateDownloaderGithub(SRPlugin plugin, SRLogger logger, Server server, PluginJarProvider jarProvider) {
        this.plugin = plugin;
        this.logger = logger;
        this.server = server;
        this.jarProvider = jarProvider;
    }
}

