/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.utils;

import java.lang.reflect.Method;
import java.util.Optional;
import org.bukkit.entity.Player;

public class BukkitReflection {
    public static final String SERVER_VERSION_STRING = BukkitReflection.getNMSVersion().orElseThrow(() -> new RuntimeException("Failed to get NMS version"));

    public static <E> E getHandle(Player player, Class<E> eClass) throws ReflectiveOperationException {
        Method getHandleMethod = BukkitReflection.getBukkitClass("entity.CraftPlayer").getDeclaredMethod("getHandle", new Class[0]);
        getHandleMethod.setAccessible(true);
        return eClass.cast(getHandleMethod.invoke((Object)player, new Object[0]));
    }

    public static Class<?> getBukkitClass(String clazz) throws ClassNotFoundException {
        return Class.forName("org.bukkit.craftbukkit." + SERVER_VERSION_STRING + "." + clazz);
    }

    public static Class<?> getNMSClass(String clazz, String fullClassName) throws ClassNotFoundException {
        try {
            return Class.forName("net.minecraft.server." + SERVER_VERSION_STRING + "." + clazz);
        }
        catch (ClassNotFoundException ignored) {
            if (fullClassName != null) {
                return Class.forName(fullClassName);
            }
            throw new ClassNotFoundException("Could not find net.minecraft.server." + SERVER_VERSION_STRING + "." + clazz);
        }
    }

    private static Optional<String> getNMSVersion() {
        String propertyVersion = System.getProperty("sr.nms.version");
        if (propertyVersion != null) {
            return Optional.of(propertyVersion);
        }
        try {
            Object bukkitServer = Class.forName("org.bukkit.Bukkit").getMethod("getServer", new Class[0]).invoke(null, new Object[0]);
            if (bukkitServer == null) {
                return Optional.empty();
            }
            String serverPackage = bukkitServer.getClass().getPackage().getName();
            return Optional.of(serverPackage.substring(serverPackage.lastIndexOf(46) + 1));
        }
        catch (ReflectiveOperationException ignored) {
            return Optional.empty();
        }
    }
}

