/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.utils;

import java.util.UUID;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.bukkit.SRBukkitAdapter;
import net.skinsrestorer.bukkit.SkinApplierBukkit;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.listeners.event.SRLoginProfileEvent;
import org.bukkit.event.player.PlayerEvent;

public class EventWrapper {
    private final SRBukkitAdapter plugin;
    private final SkinApplierBukkit skinApplier;

    public SRLoginProfileEvent<Void> wrap(final PlayerEvent event) {
        return new SRLoginProfileEvent<Void>(){

            @Override
            public boolean hasOnlineProperties() {
                return SkinApplierBukkit.getApplyAdapter().getSkinProperty(event.getPlayer()).isPresent();
            }

            @Override
            public UUID getPlayerUniqueId() {
                return event.getPlayer().getUniqueId();
            }

            @Override
            public String getPlayerName() {
                return event.getPlayer().getName();
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public void setResultProperty(SkinProperty property) {
                EventWrapper.this.skinApplier.applySkin(event.getPlayer(), property);
            }

            @Override
            public Void runAsync(Runnable runnable) {
                EventWrapper.this.plugin.runAsync(runnable);
                return null;
            }
        };
    }

    @Inject
    public EventWrapper(SRBukkitAdapter plugin, SkinApplierBukkit skinApplier) {
        this.plugin = plugin;
        this.skinApplier = skinApplier;
    }
}

