/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.utils;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import net.skinsrestorer.mappings.mapping1_18.Mapping1_18;
import net.skinsrestorer.mappings.mapping1_18_2.Mapping1_18_2;
import net.skinsrestorer.mappings.mapping1_19.Mapping1_19;
import net.skinsrestorer.mappings.mapping1_19_1.Mapping1_19_1;
import net.skinsrestorer.mappings.mapping1_19_2.Mapping1_19_2;
import net.skinsrestorer.mappings.mapping1_19_3.Mapping1_19_3;
import net.skinsrestorer.mappings.mapping1_19_4.Mapping1_19_4;
import net.skinsrestorer.mappings.mapping1_20.Mapping1_20;
import net.skinsrestorer.mappings.mapping1_20_2.Mapping1_20_2;
import net.skinsrestorer.mappings.mapping1_20_4.Mapping1_20_4;
import net.skinsrestorer.mappings.shared.IMapping;
import net.skinsrestorer.shared.utils.FluentList;
import org.bukkit.Server;
import org.bukkit.UnsafeValues;

public class MappingManager {
    private static final List<IMapping> mappings = FluentList.of(new Mapping1_18(), new Mapping1_18_2(), new Mapping1_19(), new Mapping1_19_1(), new Mapping1_19_2(), new Mapping1_19_3(), new Mapping1_19_4(), new Mapping1_20(), new Mapping1_20_2(), new Mapping1_20_4());

    public static Optional<IMapping> getMapping(Server server) {
        Optional<String> mappingVersion = MappingManager.getMappingsVersion(server);
        if (!mappingVersion.isPresent()) {
            return Optional.empty();
        }
        for (IMapping mapping : mappings) {
            if (!mapping.getSupportedVersions().contains(mappingVersion.get())) continue;
            return Optional.of(mapping);
        }
        return Optional.empty();
    }

    public static Optional<String> getMappingsVersion(Server server) {
        UnsafeValues craftMagicNumbers = server.getUnsafe();
        try {
            Method method = craftMagicNumbers.getClass().getMethod("getMappingsVersion", new Class[0]);
            return Optional.of((String)method.invoke((Object)craftMagicNumbers, new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }
}

