/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.wrapper;

import net.skinsrestorer.bukkit.SRBukkitAdapter;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.kyori.adventure.text.Component;
import net.skinsrestorer.shadow.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.skinsrestorer.shared.subjects.AbstractSRCommandSender;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.subjects.permissions.Permission;
import net.skinsrestorer.shared.utils.Tristate;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;

public class WrapperCommandSender
extends AbstractSRCommandSender {
    private final SettingsManager settings;
    private final SkinsRestorerLocale locale;
    private final SRBukkitAdapter adapter;
    private final CommandSender sender;
    private final GsonComponentSerializer serializer = GsonComponentSerializer.gson();

    @Override
    public void sendMessage(String messageJson) {
        Object message = this.serializer.deserialize(messageJson);
        Runnable runnable = () -> this.adapter.getAdventure().sender(this.sender).sendMessage((Component)message);
        if (this.sender instanceof BlockCommandSender) {
            this.adapter.runSync(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return permission.checkPermission(this.settings, p -> {
            boolean hasPermission = this.sender.hasPermission(p);
            boolean explicit = hasPermission || this.sender.isPermissionSet(p);
            return explicit ? Tristate.fromBoolean(hasPermission) : Tristate.UNDEFINED;
        });
    }

    @Override
    protected SkinsRestorerLocale getSRLocale() {
        return this.locale;
    }

    @Override
    protected SettingsManager getSettings() {
        return this.settings;
    }

    protected WrapperCommandSender(WrapperCommandSenderBuilder<?, ?> b) {
        super(b);
        this.settings = ((WrapperCommandSenderBuilder)b).settings;
        this.locale = ((WrapperCommandSenderBuilder)b).locale;
        this.adapter = ((WrapperCommandSenderBuilder)b).adapter;
        this.sender = ((WrapperCommandSenderBuilder)b).sender;
    }

    public static WrapperCommandSenderBuilder<?, ?> builder() {
        return new WrapperCommandSenderBuilderImpl();
    }

    public static abstract class WrapperCommandSenderBuilder<C extends WrapperCommandSender, B extends WrapperCommandSenderBuilder<C, B>>
    extends AbstractSRCommandSender.AbstractSRCommandSenderBuilder<C, B> {
        private SettingsManager settings;
        private SkinsRestorerLocale locale;
        private SRBukkitAdapter adapter;
        private CommandSender sender;

        public B settings(SettingsManager settings) {
            this.settings = settings;
            return (B)this.self();
        }

        public B locale(SkinsRestorerLocale locale) {
            this.locale = locale;
            return (B)this.self();
        }

        public B adapter(SRBukkitAdapter adapter) {
            this.adapter = adapter;
            return (B)this.self();
        }

        public B sender(CommandSender sender) {
            this.sender = sender;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "WrapperCommandSender.WrapperCommandSenderBuilder(super=" + super.toString() + ", settings=" + this.settings + ", locale=" + this.locale + ", adapter=" + this.adapter + ", sender=" + this.sender + ")";
        }
    }

    private static final class WrapperCommandSenderBuilderImpl
    extends WrapperCommandSenderBuilder<WrapperCommandSender, WrapperCommandSenderBuilderImpl> {
        private WrapperCommandSenderBuilderImpl() {
        }

        @Override
        protected WrapperCommandSenderBuilderImpl self() {
            return this;
        }

        @Override
        public WrapperCommandSender build() {
            return new WrapperCommandSender(this);
        }
    }
}

