/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee;

import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.connection.InitialHandler;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.bungee.SkinApplierBungeeNew;
import net.skinsrestorer.bungee.SkinApplierBungeeOld;
import net.skinsrestorer.bungee.SkinApplyBungeeAdapter;
import net.skinsrestorer.bungee.wrapper.WrapperBungee;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shared.api.SkinApplierAccess;
import net.skinsrestorer.shared.api.event.EventBusImpl;
import net.skinsrestorer.shared.api.event.SkinApplyEventImpl;
import net.skinsrestorer.shared.config.AdvancedConfig;
import net.skinsrestorer.shared.plugin.SRProxyPlugin;
import net.skinsrestorer.shared.utils.ReflectionUtil;

public class SkinApplierBungee
implements SkinApplierAccess<ProxiedPlayer> {
    public static final boolean IS_NEW_PROPERTY_CLASS = ReflectionUtil.classExists("net.md_5.bungee.protocol.Property");
    private static final SkinApplyBungeeAdapter applyAdapter = SkinApplierBungee.selectSkinApplyAdapter();
    private final SettingsManager settings;
    private final WrapperBungee wrapper;
    private final SRProxyPlugin proxyPlugin;
    private final EventBusImpl eventBus;

    private static SkinApplyBungeeAdapter selectSkinApplyAdapter() {
        if (IS_NEW_PROPERTY_CLASS) {
            return new SkinApplierBungeeNew();
        }
        return new SkinApplierBungeeOld();
    }

    @Override
    public void applySkin(ProxiedPlayer player, SkinProperty property) {
        try {
            this.applyEvent(player, property, (InitialHandler)player.getPendingConnection());
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public void applySkin(SkinProperty property, InitialHandler handler) {
        try {
            this.applyEvent(null, property, handler);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    private void applyEvent(@Nullable ProxiedPlayer player, SkinProperty property, InitialHandler handler) throws ReflectiveOperationException {
        SkinApplyEventImpl event = new SkinApplyEventImpl(player, property);
        this.eventBus.callEvent(event);
        if (event.isCancelled()) {
            return;
        }
        this.applyWithProperty(player, handler, event.getProperty());
    }

    private void applyWithProperty(@Nullable ProxiedPlayer player, InitialHandler handler, SkinProperty textures) throws ReflectiveOperationException {
        applyAdapter.applyToHandler(handler, textures);
        if (player == null) {
            return;
        }
        this.proxyPlugin.sendUpdateRequest(this.wrapper.player(player), this.settings.getProperty(AdvancedConfig.FORWARD_TEXTURES) != false ? textures : null);
    }

    @Inject
    public SkinApplierBungee(SettingsManager settings, WrapperBungee wrapper, SRProxyPlugin proxyPlugin, EventBusImpl eventBus) {
        this.settings = settings;
        this.wrapper = wrapper;
        this.proxyPlugin = proxyPlugin;
        this.eventBus = eventBus;
    }

    public static SkinApplyBungeeAdapter getApplyAdapter() {
        return applyAdapter;
    }
}

