/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configme.beanmapper;

import net.skinsrestorer.shadow.configme.beanmapper.MappingContext;
import net.skinsrestorer.shadow.configme.properties.convertresult.ConvertErrorRecorder;
import net.skinsrestorer.shadow.configme.utils.TypeInformation;
import net.skinsrestorer.shadow.jbannotations.NotNull;

public class MappingContextImpl
implements MappingContext {
    private final String path;
    private final TypeInformation typeInformation;
    private final ConvertErrorRecorder errorRecorder;

    protected MappingContextImpl(@NotNull String path, @NotNull TypeInformation typeInformation, @NotNull ConvertErrorRecorder errorRecorder) {
        this.path = path;
        this.typeInformation = typeInformation;
        this.errorRecorder = errorRecorder;
    }

    @NotNull
    public static MappingContextImpl createRoot(@NotNull TypeInformation typeInformation, @NotNull ConvertErrorRecorder errorRecorder) {
        return new MappingContextImpl("", typeInformation, errorRecorder);
    }

    @Override
    @NotNull
    public MappingContext createChild(@NotNull String subPath, @NotNull TypeInformation typeInformation) {
        if (this.path.isEmpty()) {
            return new MappingContextImpl(subPath, typeInformation, this.errorRecorder);
        }
        return new MappingContextImpl(this.path + "." + subPath, typeInformation, this.errorRecorder);
    }

    @Override
    @NotNull
    public TypeInformation getTypeInformation() {
        return this.typeInformation;
    }

    @Override
    @NotNull
    public String createDescription() {
        return "Path: '" + this.path + "', type: '" + this.typeInformation.getType() + "'";
    }

    @Override
    public void registerError(@NotNull String reason) {
        this.errorRecorder.setHasError("At path '" + this.path + "': " + reason);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.createDescription() + "]";
    }
}

