/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configme.configurationdata;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.skinsrestorer.shadow.configme.SettingsHolder;
import net.skinsrestorer.shadow.configme.configurationdata.ConfigurationData;
import net.skinsrestorer.shadow.configme.exception.ConfigMeException;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.configme.properties.convertresult.PropertyValue;
import net.skinsrestorer.shadow.configme.resource.PropertyReader;
import net.skinsrestorer.shadow.jbannotations.NotNull;

public class ConfigurationDataImpl
implements ConfigurationData {
    @NotNull
    private final List<Property<?>> properties;
    @NotNull
    private final Map<String, List<String>> allComments;
    @NotNull
    private final List<String> footerComments;
    @NotNull
    private final Map<String, Object> values;
    private boolean allPropertiesValidInResource;

    protected ConfigurationDataImpl(@NotNull List<? extends Property<?>> allProperties, @NotNull Map<String, List<String>> allComments, @NotNull List<String> footerComments) {
        this.properties = Collections.unmodifiableList(allProperties);
        this.allComments = Collections.unmodifiableMap(allComments);
        this.footerComments = Collections.unmodifiableList(footerComments);
        this.values = new HashMap<String, Object>();
    }

    @Override
    @NotNull
    public List<Property<?>> getProperties() {
        return this.properties;
    }

    @Override
    @NotNull
    public List<String> getCommentsForSection(String path) {
        return this.allComments.getOrDefault(path, Collections.emptyList());
    }

    @Override
    @NotNull
    public Map<String, List<String>> getAllComments() {
        return this.allComments;
    }

    @Override
    @NotNull
    public List<String> getFooterComments() {
        return this.footerComments;
    }

    @Override
    public <T> T getValue(@NotNull Property<T> property) {
        Object value = this.values.get(property.getPath());
        if (value == null) {
            throw new ConfigMeException(String.format("No value exists for property with path '%s'. This may happen if the property belongs to a %s class which was not passed to the settings manager.", property.getPath(), SettingsHolder.class.getSimpleName()));
        }
        return (T)value;
    }

    @Override
    public <T> void setValue(@NotNull Property<T> property, @NotNull T value) {
        if (!property.isValidValue(value)) {
            throw new ConfigMeException("Invalid value for property '" + property + "': " + value);
        }
        this.values.put(property.getPath(), value);
    }

    @Override
    public void initializeValues(@NotNull PropertyReader reader) {
        this.values.clear();
        this.allPropertiesValidInResource = this.getProperties().stream().map(property -> this.setValueForProperty((Property)property, reader)).reduce(true, Boolean::logicalAnd);
    }

    protected <T> boolean setValueForProperty(@NotNull Property<T> property, @NotNull PropertyReader reader) {
        PropertyValue<T> propertyValue = property.determineValue(reader);
        this.setValue(property, propertyValue.getValue());
        return propertyValue.isValidInResource();
    }

    @Override
    public boolean areAllValuesValidInResource() {
        return this.allPropertiesValidInResource;
    }

    @NotNull
    protected Map<String, Object> getValues() {
        return this.values;
    }
}

