/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configme.properties;

import java.util.Objects;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.configme.properties.convertresult.ConvertErrorRecorder;
import net.skinsrestorer.shadow.configme.properties.convertresult.PropertyValue;
import net.skinsrestorer.shadow.configme.resource.PropertyReader;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;

public abstract class BaseProperty<T>
implements Property<T> {
    private final String path;
    private final T defaultValue;

    public BaseProperty(@NotNull String path, @NotNull T defaultValue) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(defaultValue, "defaultValue");
        this.path = path;
        this.defaultValue = defaultValue;
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    @NotNull
    public PropertyValue<T> determineValue(@NotNull PropertyReader reader) {
        ConvertErrorRecorder errorRecorder = new ConvertErrorRecorder();
        T value = this.getFromReader(reader, errorRecorder);
        if (this.isValidValue(value)) {
            return new PropertyValue<T>(value, errorRecorder.isFullyValid());
        }
        return PropertyValue.withValueRequiringRewrite(this.getDefaultValue());
    }

    @Override
    public boolean isValidValue(@Nullable T value) {
        return value != null;
    }

    @Nullable
    protected abstract T getFromReader(@NotNull PropertyReader var1, @NotNull ConvertErrorRecorder var2);

    @NotNull
    public String toString() {
        return "Property '" + this.path + "'";
    }
}

