/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configme.resource;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.skinsrestorer.shadow.configme.configurationdata.ConfigurationData;
import net.skinsrestorer.shadow.configme.exception.ConfigMeException;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.configme.resource.PropertyPathTraverser;
import net.skinsrestorer.shadow.configme.resource.PropertyReader;
import net.skinsrestorer.shadow.configme.resource.PropertyResource;
import net.skinsrestorer.shadow.configme.resource.YamlFileReader;
import net.skinsrestorer.shadow.configme.resource.YamlFileResourceOptions;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shadow.snakeyaml.DumperOptions;
import net.skinsrestorer.shadow.snakeyaml.Yaml;

public class YamlFileResource
implements PropertyResource {
    private final Path path;
    @NotNull
    private final YamlFileResourceOptions options;
    private final String indentationSpace;
    @Nullable
    private Yaml yamlObject;

    public YamlFileResource(@NotNull Path path) {
        this(path, YamlFileResourceOptions.builder().build());
    }

    public YamlFileResource(@NotNull Path path, @NotNull YamlFileResourceOptions options) {
        this.path = path;
        this.options = options;
        this.indentationSpace = options.getIndentation();
    }

    @Deprecated
    public YamlFileResource(@NotNull File file) {
        this(file.toPath());
    }

    @Override
    @NotNull
    public PropertyReader createReader() {
        return new YamlFileReader(this.path, this.options.getCharset(), this.options.splitDotPaths());
    }

    @Override
    public void exportProperties(@NotNull ConfigurationData configurationData) {
        try (OutputStream os = Files.newOutputStream(this.path, new OpenOption[0]);
             OutputStreamWriter writer = new OutputStreamWriter(os, this.options.getCharset());){
            PropertyPathTraverser pathTraverser = new PropertyPathTraverser(configurationData);
            for (Property<?> property : configurationData.getProperties()) {
                Object exportValue = this.getExportValue(property, configurationData);
                this.exportValue(writer, pathTraverser, Arrays.asList(property.getPath().split("\\.")), exportValue);
            }
            for (String footerComment : configurationData.getFooterComments()) {
                if (footerComment.startsWith("\n")) {
                    writer.append(footerComment);
                    continue;
                }
                writer.append("\n").append("# ").append(footerComment);
            }
            writer.append("\n");
            writer.flush();
        }
        catch (IOException e) {
            throw new ConfigMeException("Could not save config to '" + this.path + "'", e);
        }
        finally {
            this.onWriteComplete();
        }
    }

    @NotNull
    protected final Path getPath() {
        return this.path;
    }

    @Deprecated
    @NotNull
    protected final File getFile() {
        return this.path.toFile();
    }

    protected void exportValue(@NotNull Writer writer, @NotNull PropertyPathTraverser pathTraverser, @NotNull List<String> pathElements, @Nullable Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof Map && !((Map)value).isEmpty()) {
            Map mapValue = (Map)value;
            for (Map.Entry entry : mapValue.entrySet()) {
                List<String> pathElementsForEntry = this.combinePathElementsAndMapEntryKey(pathElements, (String)entry.getKey());
                this.exportValue(writer, pathTraverser, pathElementsForEntry, entry.getValue());
            }
        } else {
            List<PropertyPathTraverser.PathElement> newPathElements = pathTraverser.getPathElements(pathElements);
            boolean isRootProperty = newPathElements.size() == 1 && "".equals(newPathElements.get(0).getName());
            for (PropertyPathTraverser.PathElement pathElement : newPathElements) {
                this.writeIndentingBetweenLines(writer, pathElement);
                this.writeComments(writer, pathElement.getIndentationLevel(), pathElement);
                writer.append(this.getNewLineIfNotFirstElement(pathElement));
                if (isRootProperty) continue;
                writer.append(this.indent(pathElement.getIndentationLevel())).append(this.escapePathElementIfNeeded(pathElement.getName())).append(":");
            }
            if (!isRootProperty) {
                writer.append(" ");
            }
            writer.append(this.toYamlIndented(value, newPathElements.get(newPathElements.size() - 1).getIndentationLevel()));
        }
    }

    protected void writeComments(@NotNull Writer writer, int indentation, @NotNull PropertyPathTraverser.PathElement pathElement) throws IOException {
        if (pathElement.getComments().isEmpty()) {
            return;
        }
        String lineStart = pathElement.isFirstElement() ? "" : "\n";
        String indent = this.indent(indentation);
        String commentStart = indent + "# ";
        for (String comment : pathElement.getComments()) {
            writer.append(lineStart);
            lineStart = "\n";
            if ("\n".equals(comment)) continue;
            writer.append(comment.startsWith("\n") ? indent : commentStart).append(comment.startsWith("\n") ? comment.substring(1) : comment);
        }
    }

    protected List<String> combinePathElementsAndMapEntryKey(List<String> parentPathElements, String mapEntryKey) {
        Stream parentPathElems = parentPathElements.size() == 1 && "".equals(parentPathElements.get(0)) ? Stream.empty() : parentPathElements.stream();
        Stream<String> pathElemsFromEntryKey = this.options.splitDotPaths() ? Arrays.stream(mapEntryKey.split("\\.")) : Stream.of(mapEntryKey);
        return Stream.concat(parentPathElems, pathElemsFromEntryKey).collect(Collectors.toList());
    }

    private void writeIndentingBetweenLines(@NotNull Writer writer, @NotNull PropertyPathTraverser.PathElement pathElement) throws IOException {
        int numberOfEmptyLines = this.options.getNumberOfEmptyLinesBefore(pathElement);
        for (int i = 0; i < numberOfEmptyLines; ++i) {
            writer.append("\n");
        }
    }

    @NotNull
    private String getNewLineIfNotFirstElement(@NotNull PropertyPathTraverser.PathElement pathElement) {
        return pathElement.isFirstElement() && pathElement.getComments().isEmpty() ? "" : "\n";
    }

    @NotNull
    protected String toYamlIndented(@Nullable Object value, int indent) {
        String representation = this.toYaml(value);
        CharSequence[] lines = representation.split("\\n");
        return String.join((CharSequence)("\n" + this.indent(indent)), lines);
    }

    protected String toYaml(@Nullable Object value) {
        if (value instanceof String) {
            return this.getYamlObject().dump(value);
        }
        if (value instanceof Collection) {
            List<?> list = YamlFileResource.collectionToList((Collection)value);
            return list.isEmpty() ? "[]" : "\n" + this.getYamlObject().dump(list);
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            return array.length == 0 ? "[]" : "\n" + this.getYamlObject().dump(array);
        }
        return this.getYamlObject().dump(value);
    }

    protected String indent(int level) {
        switch (level) {
            case 0: {
                return "";
            }
            case 1: {
                return this.indentationSpace;
            }
            case 2: {
                return this.indentationSpace + this.indentationSpace;
            }
            case 3: {
                return this.indentationSpace + this.indentationSpace + this.indentationSpace;
            }
            case 4: {
                return this.indentationSpace + this.indentationSpace + this.indentationSpace + this.indentationSpace;
            }
            case 5: {
                return this.indentationSpace + this.indentationSpace + this.indentationSpace + this.indentationSpace + this.indentationSpace;
            }
        }
        StringBuilder result = new StringBuilder(level * this.indentationSpace.length());
        for (int i = 0; i < level; ++i) {
            result.append(this.indentationSpace);
        }
        return result.toString();
    }

    @NotNull
    protected String escapePathElementIfNeeded(@NotNull String path) {
        return this.getYamlObject().dump(path).trim();
    }

    protected void onWriteComplete() {
        this.yamlObject = null;
    }

    @NotNull
    protected Yaml getYamlObject() {
        if (this.yamlObject == null) {
            this.yamlObject = this.createNewYaml();
        }
        return this.yamlObject;
    }

    @NotNull
    protected Yaml createNewYaml() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setAllowUnicode(true);
        return new Yaml(options);
    }

    @NotNull
    protected final YamlFileResourceOptions getOptions() {
        return this.options;
    }

    @Nullable
    private <T> Object getExportValue(@NotNull Property<T> property, @NotNull ConfigurationData configurationData) {
        return property.toExportValue(configurationData.getValue(property));
    }

    @NotNull
    private static List<?> collectionToList(@NotNull Collection<?> collection) {
        return collection instanceof List ? (List<Object>)collection : new ArrayList(collection);
    }
}

