/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.injector.handlers.dependency;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import net.skinsrestorer.shadow.injector.context.ResolutionContext;
import net.skinsrestorer.shadow.injector.exceptions.InjectorException;
import net.skinsrestorer.shadow.injector.handlers.Handler;
import net.skinsrestorer.shadow.injector.handlers.instantiation.Resolution;
import net.skinsrestorer.shadow.injector.handlers.instantiation.SimpleResolution;
import net.skinsrestorer.shadow.injector.utils.InjectorUtils;

public class SavedAnnotationsHandler
implements Handler {
    private Map<Class<?>, Object> storedValues = new HashMap();

    @Override
    public Resolution<?> resolve(ResolutionContext context) {
        for (Annotation annotation : context.getIdentifier().getAnnotations()) {
            Object o = this.storedValues.get(annotation.annotationType());
            if (o == null) continue;
            return new SimpleResolution<Object>(o);
        }
        return null;
    }

    @Override
    public void onAnnotation(Class<? extends Annotation> annotation, Object object) {
        InjectorUtils.checkNotNull(object, "Object may not be null");
        if (this.storedValues.containsKey(annotation)) {
            throw new InjectorException("Value already registered for @" + annotation.getSimpleName());
        }
        this.storedValues.put(annotation, object);
    }
}

