/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.client.column;

import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Timestamp;
import java.util.Calendar;
import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.client.DataType;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.column.UnsignedSmallIntColumn;
import net.skinsrestorer.shadow.mariadb.client.util.MutableInt;

public class YearColumn
extends UnsignedSmallIntColumn {
    public YearColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat);
    }

    protected YearColumn(YearColumn prev) {
        super(prev);
    }

    @Override
    public YearColumn useAliasAsName() {
        return new YearColumn(this);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return conf.yearIsDateType() ? Date.class.getName() : Short.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return conf.yearIsDateType() ? 91 : 5;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        return "YEAR";
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (conf.yearIsDateType()) {
            short y = (short)buf.atoull(length.get());
            if (this.columnLength == 2L) {
                y = y <= 69 ? (short)(y + 2000) : (short)(y + 1900);
            }
            return Date.valueOf(y + "-01-01");
        }
        return this.decodeShortText(buf, length);
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (conf.yearIsDateType()) {
            int v = buf.readShort();
            if (this.columnLength == 2L) {
                v = v <= 69 ? (v += 2000) : (v += 1900);
            }
            return Date.valueOf(v + "-01-01");
        }
        return this.decodeShortText(buf, length);
    }

    @Override
    public Date decodeDateText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        short y = (short)buf.atoll(length.get());
        if (this.columnLength == 2L) {
            y = y <= 69 ? (short)(y + 2000) : (short)(y + 1900);
        }
        return Date.valueOf(y + "-01-01");
    }

    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        int v = buf.readShort();
        if (this.columnLength == 2L) {
            v = v <= 69 ? (v += 2000) : (v += 1900);
        }
        return Date.valueOf(v + "-01-01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, MutableInt length, Calendar calParam) throws SQLDataException {
        int year = Integer.parseInt(buf.readAscii(length.get()));
        if (this.columnLength <= 2L) {
            year += year >= 70 ? 1900 : 2000;
        }
        if (calParam == null) {
            Calendar cal1 = Calendar.getInstance();
            cal1.clear();
            cal1.set(year, 0, 1);
            return new Timestamp(cal1.getTimeInMillis());
        }
        Calendar calendar = calParam;
        synchronized (calendar) {
            calParam.clear();
            calParam.set(year, 0, 1);
            return new Timestamp(calParam.getTimeInMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, MutableInt length, Calendar calParam) throws SQLDataException {
        Timestamp timestamp;
        int year = buf.readUnsignedShort();
        if (this.columnLength <= 2L) {
            year += year >= 70 ? 1900 : 2000;
        }
        if (calParam == null) {
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.set(year, 0, 1, 0, 0, 0);
            timestamp = new Timestamp(cal.getTimeInMillis());
        } else {
            Calendar calendar = calParam;
            synchronized (calendar) {
                calParam.clear();
                calParam.set(year, 0, 1, 0, 0, 0);
                timestamp = new Timestamp(calParam.getTimeInMillis());
            }
        }
        timestamp.setNanos(0);
        return timestamp;
    }
}

