/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.client.result;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.Statement;
import net.skinsrestorer.shadow.mariadb.client.ColumnDecoder;
import net.skinsrestorer.shadow.mariadb.client.Completion;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.impl.StandardReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.result.ResultSetMetaData;
import net.skinsrestorer.shadow.mariadb.client.result.rowdecoder.BinaryRowDecoder;
import net.skinsrestorer.shadow.mariadb.client.result.rowdecoder.RowDecoder;
import net.skinsrestorer.shadow.mariadb.client.result.rowdecoder.TextRowDecoder;
import net.skinsrestorer.shadow.mariadb.client.util.MutableInt;
import net.skinsrestorer.shadow.mariadb.export.ExceptionFactory;
import net.skinsrestorer.shadow.mariadb.message.server.ErrorPacket;
import net.skinsrestorer.shadow.mariadb.plugin.Codec;
import net.skinsrestorer.shadow.mariadb.plugin.codec.BigDecimalCodec;
import net.skinsrestorer.shadow.mariadb.plugin.codec.BigIntegerCodec;
import net.skinsrestorer.shadow.mariadb.plugin.codec.BlobCodec;
import net.skinsrestorer.shadow.mariadb.plugin.codec.ByteArrayCodec;
import net.skinsrestorer.shadow.mariadb.plugin.codec.ClobCodec;
import net.skinsrestorer.shadow.mariadb.plugin.codec.ReaderCodec;
import net.skinsrestorer.shadow.mariadb.plugin.codec.StreamCodec;
import net.skinsrestorer.shadow.mariadb.plugin.codec.StringCodec;

public abstract class Result
implements ResultSet,
Completion {
    public static final int NULL_LENGTH = -1;
    private static final BinaryRowDecoder BINARY_ROW_DECODER = new BinaryRowDecoder();
    private static final TextRowDecoder TEXT_ROW_DECODER = new TextRowDecoder();
    protected final int resultSetType;
    protected final ExceptionFactory exceptionFactory;
    protected final net.skinsrestorer.shadow.mariadb.client.socket.Reader reader;
    protected final Context context;
    protected final ColumnDecoder[] metadataList;
    protected final RowDecoder rowDecoder;
    protected final StandardReadableByteBuf rowBuf = new StandardReadableByteBuf(null, 0);
    protected final boolean traceEnable;
    private final int maxIndex;
    private final boolean closeOnCompletion;
    private final MutableInt fieldLength = new MutableInt(0);
    private final boolean forceAlias;
    private final byte[] nullBitmap;
    protected int dataSize = 0;
    protected byte[][] data;
    protected MutableInt fieldIndex = new MutableInt();
    protected boolean loaded;
    protected boolean outputParameter;
    protected int rowPointer = -1;
    protected boolean closed;
    protected java.sql.Statement statement;
    protected long maxRows;
    private Map<String, Integer> mapper = null;
    private int fetchSize;

    public Result(Statement stmt, boolean binaryProtocol, long maxRows, ColumnDecoder[] metadataList, net.skinsrestorer.shadow.mariadb.client.socket.Reader reader, Context context, int resultSetType, boolean closeOnCompletion, boolean traceEnable, boolean forceAlias, int fetchSize) {
        this.maxRows = maxRows;
        this.statement = stmt;
        this.closeOnCompletion = closeOnCompletion;
        this.metadataList = metadataList;
        this.maxIndex = this.metadataList.length;
        this.reader = reader;
        this.exceptionFactory = context.getExceptionFactory();
        this.context = context;
        this.resultSetType = resultSetType;
        this.traceEnable = traceEnable;
        this.forceAlias = forceAlias;
        this.fetchSize = fetchSize;
        if (binaryProtocol) {
            this.rowDecoder = BINARY_ROW_DECODER;
            this.nullBitmap = new byte[(this.maxIndex + 9) / 8];
        } else {
            this.rowDecoder = TEXT_ROW_DECODER;
            this.nullBitmap = null;
        }
    }

    protected Result(ColumnDecoder[] metadataList, Result prev) {
        this.maxRows = prev.maxRows;
        this.statement = prev.statement;
        this.closeOnCompletion = prev.closeOnCompletion;
        this.metadataList = metadataList;
        this.maxIndex = metadataList.length;
        this.reader = prev.reader;
        this.exceptionFactory = prev.exceptionFactory;
        this.context = prev.context;
        this.resultSetType = prev.resultSetType;
        this.traceEnable = prev.traceEnable;
        this.forceAlias = true;
        this.rowDecoder = prev.rowDecoder;
        this.nullBitmap = prev.nullBitmap;
    }

    public Result(ColumnDecoder[] metadataList, byte[][] data, Context context, int resultSetType) {
        this.metadataList = metadataList;
        this.maxIndex = this.metadataList.length;
        this.reader = null;
        this.loaded = true;
        this.exceptionFactory = context.getExceptionFactory();
        this.context = context;
        this.data = data;
        this.dataSize = data.length;
        this.statement = null;
        this.resultSetType = resultSetType;
        this.closeOnCompletion = false;
        this.traceEnable = false;
        this.rowDecoder = TEXT_ROW_DECODER;
        this.nullBitmap = null;
        this.forceAlias = false;
    }

    protected boolean readNext(byte[] buf) throws IOException, SQLException {
        switch (buf[0]) {
            case -1: {
                this.loaded = true;
                ErrorPacket errorPacket = new ErrorPacket(this.reader.readableBufFromArray(buf), this.context);
                throw this.exceptionFactory.create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
            }
            case -2: {
                int serverStatus;
                int warnings;
                if ((!this.context.isEofDeprecated() || buf.length >= 0xFFFFFF) && (this.context.isEofDeprecated() || buf.length >= 8)) break;
                ReadableByteBuf readBuf = this.reader.readableBufFromArray(buf);
                readBuf.skip();
                if (!this.context.isEofDeprecated()) {
                    warnings = readBuf.readUnsignedShort();
                    serverStatus = readBuf.readUnsignedShort();
                } else {
                    readBuf.readLongLengthEncodedNotNull();
                    readBuf.readLongLengthEncodedNotNull();
                    serverStatus = readBuf.readUnsignedShort();
                    warnings = readBuf.readUnsignedShort();
                }
                this.outputParameter = (serverStatus & 0x1000) != 0;
                this.context.setServerStatus(serverStatus);
                this.context.setWarning(warnings);
                this.loaded = true;
                return false;
            }
        }
        if (this.dataSize + 1 > this.data.length) {
            this.growDataArray();
        }
        this.data[this.dataSize++] = buf;
        return true;
    }

    protected void skipRemaining() throws IOException, SQLException {
        block4: while (true) {
            ReadableByteBuf buf = this.reader.readReusablePacket(this.traceEnable);
            switch (buf.getUnsignedByte()) {
                case 255: {
                    this.loaded = true;
                    ErrorPacket errorPacket = new ErrorPacket(buf, this.context);
                    throw this.exceptionFactory.create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
                }
                case 254: {
                    int serverStatus;
                    int warnings;
                    if ((!this.context.isEofDeprecated() || buf.readableBytes() >= 0xFFFFFF) && (this.context.isEofDeprecated() || buf.readableBytes() >= 8)) continue block4;
                    buf.skip();
                    if (!this.context.isEofDeprecated()) {
                        warnings = buf.readUnsignedShort();
                        serverStatus = buf.readUnsignedShort();
                    } else {
                        buf.readLongLengthEncodedNotNull();
                        buf.readLongLengthEncodedNotNull();
                        serverStatus = buf.readUnsignedShort();
                        warnings = buf.readUnsignedShort();
                    }
                    this.outputParameter = (serverStatus & 0x1000) != 0;
                    this.context.setServerStatus(serverStatus);
                    this.context.setWarning(warnings);
                    this.loaded = true;
                    return;
                }
            }
        }
    }

    private void growDataArray() {
        int newCapacity = Math.max(10, this.data.length + (this.data.length >> 1));
        byte[][] newData = new byte[newCapacity][];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        this.data = newData;
    }

    @Override
    public abstract boolean next() throws SQLException;

    public abstract boolean streaming();

    public abstract void fetchRemaining() throws SQLException;

    public boolean loaded() {
        return this.loaded;
    }

    public boolean isOutputParameter() {
        return this.outputParameter;
    }

    @Override
    public void close() throws SQLException {
        if (!this.loaded) {
            try {
                this.skipRemaining();
            }
            catch (IOException ioe) {
                throw this.exceptionFactory.create("Error while streaming resultSet data", "08000", ioe);
            }
        }
        this.closed = true;
        if (this.closeOnCompletion) {
            this.statement.close();
        }
    }

    public void closeFromStmtClose(ReentrantLock lock) throws SQLException {
        lock.lock();
        try {
            this.fetchRemaining();
            this.closed = true;
        }
        finally {
            lock.unlock();
        }
    }

    public void abort() {
        this.closed = true;
    }

    protected byte[] getCurrentRowData() {
        return this.data[0];
    }

    protected void addRowData(byte[] buf) {
        if (this.dataSize + 1 > this.data.length) {
            this.growDataArray();
        }
        this.data[this.dataSize++] = buf;
    }

    protected void updateRowData(byte[] rawData) {
        this.data[this.rowPointer] = rawData;
        if (rawData == null) {
            this.setNullRowBuf();
        } else {
            this.setRow(rawData);
            this.fieldIndex.set(-1);
        }
    }

    private void checkIndex(int index) throws SQLException {
        if (index < 1 || index > this.maxIndex) {
            throw new SQLException(String.format("Wrong index position. Is %s but must be in 1-%s range", index, this.maxIndex));
        }
        if (this.rowBuf.buf == null) {
            throw new SQLDataException("wrong row position", "22023");
        }
    }

    @Override
    public boolean wasNull() {
        return this.rowDecoder.wasNull(this.nullBitmap, this.fieldIndex, this.fieldLength);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return this.rowDecoder.decodeString(this.metadataList, this.fieldIndex, this.rowBuf, this.fieldLength);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return false;
        }
        return this.rowDecoder.decodeBoolean(this.metadataList, this.fieldIndex, this.rowBuf, this.fieldLength);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return 0;
        }
        return this.rowDecoder.decodeByte(this.metadataList, this.fieldIndex, this.rowBuf, this.fieldLength);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return 0;
        }
        return this.rowDecoder.decodeShort(this.metadataList, this.fieldIndex, this.rowBuf, this.fieldLength);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return 0;
        }
        return this.rowDecoder.decodeInt(this.metadataList, this.fieldIndex, this.rowBuf, this.fieldLength);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return 0L;
        }
        return this.rowDecoder.decodeLong(this.metadataList, this.fieldIndex, this.rowBuf, this.fieldLength);
    }

    public BigInteger getBigInteger(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return this.rowDecoder.decode(BigIntegerCodec.INSTANCE, null, this.rowBuf, this.fieldLength, this.metadataList, this.fieldIndex);
    }

    public BigInteger getBigInteger(String columnLabel) throws SQLException {
        return this.getBigInteger(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return 0.0f;
        }
        return this.rowDecoder.decodeFloat(this.metadataList, this.fieldIndex, this.rowBuf, this.fieldLength);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return 0.0;
        }
        return this.rowDecoder.decodeDouble(this.metadataList, this.fieldIndex, this.rowBuf, this.fieldLength);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        BigDecimal d = this.rowDecoder.decode(BigDecimalCodec.INSTANCE, null, this.rowBuf, this.fieldLength, this.metadataList, this.fieldIndex);
        if (d == null) {
            return null;
        }
        return d.setScale(scale, RoundingMode.HALF_DOWN);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return this.rowDecoder.decode(ByteArrayCodec.INSTANCE, null, this.rowBuf, this.fieldLength, this.metadataList, this.fieldIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return this.rowDecoder.decodeDate(this.metadataList, this.fieldIndex, this.rowBuf, this.fieldLength, null);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return this.rowDecoder.decodeTime(this.metadataList, this.fieldIndex, this.rowBuf, this.fieldLength, null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return this.rowDecoder.decodeTimestamp(this.metadataList, this.fieldIndex, this.rowBuf, this.fieldLength, null);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return this.rowDecoder.decode(StreamCodec.INSTANCE, null, this.rowBuf, this.fieldLength, this.metadataList, this.fieldIndex);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return this.rowDecoder.decode(StreamCodec.INSTANCE, null, this.rowBuf, this.fieldLength, this.metadataList, this.fieldIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return this.rowDecoder.decode(StreamCodec.INSTANCE, null, this.rowBuf, this.fieldLength, this.metadataList, this.fieldIndex);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.statement == null) {
            return null;
        }
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.statement != null) {
            this.statement.clearWarnings();
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        throw this.exceptionFactory.notSupported("Cursors are not supported");
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return new ResultSetMetaData(this.exceptionFactory, this.metadataList, this.context.getConf(), this.forceAlias);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return this.rowDecoder.defaultDecode(this.context.getConf(), this.metadataList, this.fieldIndex, this.rowBuf, this.fieldLength);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return this.rowDecoder.decode(ReaderCodec.INSTANCE, null, this.rowBuf, this.fieldLength, this.metadataList, this.fieldIndex);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return this.rowDecoder.decode(BigDecimalCodec.INSTANCE, null, this.rowBuf, this.fieldLength, this.metadataList, this.fieldIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    protected void checkClose() throws SQLException {
        if (this.closed) {
            throw this.exceptionFactory.create("Operation not permit on a closed resultSet", "HY000");
        }
    }

    protected void checkNotForwardOnly() throws SQLException {
        if (this.resultSetType == 1003) {
            throw this.exceptionFactory.create("Operation not permit on TYPE_FORWARD_ONLY resultSet", "HY000");
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClose();
        return this.rowPointer == -1 && this.dataSize > 0;
    }

    @Override
    public abstract boolean isAfterLast() throws SQLException;

    @Override
    public abstract boolean isFirst() throws SQLException;

    @Override
    public abstract boolean isLast() throws SQLException;

    @Override
    public abstract void beforeFirst() throws SQLException;

    @Override
    public abstract void afterLast() throws SQLException;

    @Override
    public abstract boolean first() throws SQLException;

    @Override
    public abstract boolean last() throws SQLException;

    @Override
    public abstract int getRow() throws SQLException;

    public void setRow(byte[] row) {
        this.rowBuf.buf(row, row.length, 0);
        this.fieldIndex.set(-1);
    }

    @Override
    public abstract boolean absolute(int var1) throws SQLException;

    @Override
    public abstract boolean relative(int var1) throws SQLException;

    @Override
    public abstract boolean previous() throws SQLException;

    @Override
    public int getFetchDirection() {
        return 1002;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction == 1001) {
            throw this.exceptionFactory.create("Invalid operation. Allowed direction are ResultSet.FETCH_FORWARD and ResultSet.FETCH_UNKNOWN");
        }
    }

    @Override
    public int getType() {
        return this.resultSetType;
    }

    @Override
    public int getConcurrency() {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void insertRow() throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateRow() throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public java.sql.Statement getStatement() {
        return this.statement;
    }

    public void setStatement(java.sql.Statement stmt) {
        this.statement = stmt;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return this.getObject(columnIndex);
        }
        throw this.exceptionFactory.notSupported("Method ResultSet.getObject(int columnIndex, Map<String, Class<?>> map) not supported for non empty map");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw this.exceptionFactory.notSupported("Method ResultSet.getRef not supported");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return this.rowDecoder.decode(BlobCodec.INSTANCE, null, this.rowBuf, this.fieldLength, this.metadataList, this.fieldIndex);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return this.rowDecoder.decode(ClobCodec.INSTANCE, null, this.rowBuf, this.fieldLength, this.metadataList, this.fieldIndex);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw this.exceptionFactory.notSupported("Method ResultSet.getArray not supported");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return this.getObject(columnLabel);
        }
        throw this.exceptionFactory.notSupported("Method ResultSet.getObject(String columnLabel, Map<String, Class<?>> map) not supported");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw this.exceptionFactory.notSupported("Method ResultSet.getRef not supported");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw this.exceptionFactory.notSupported("Method ResultSet.getArray not supported");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return this.rowDecoder.decodeDate(this.metadataList, this.fieldIndex, this.rowBuf, this.fieldLength, cal);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return this.rowDecoder.decodeTime(this.metadataList, this.fieldIndex, this.rowBuf, this.fieldLength, cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return this.rowDecoder.decodeTimestamp(this.metadataList, this.fieldIndex, this.rowBuf, this.fieldLength, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        String s = this.rowDecoder.decode(StringCodec.INSTANCE, null, this.rowBuf, this.fieldLength, this.metadataList, this.fieldIndex);
        if (s == null) {
            return null;
        }
        try {
            return new URI(s).toURL();
        }
        catch (Exception e) {
            throw this.exceptionFactory.create(String.format("Could not parse '%s' as URL", s));
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw this.exceptionFactory.notSupported("Method ResultSet.updateRef not supported");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw this.exceptionFactory.notSupported("Method ResultSet.updateRef not supported");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw this.exceptionFactory.notSupported("Array are not supported");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw this.exceptionFactory.notSupported("Array are not supported");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw this.exceptionFactory.notSupported("RowId are not supported");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw this.exceptionFactory.notSupported("RowId are not supported");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw this.exceptionFactory.notSupported("RowId are not supported");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw this.exceptionFactory.notSupported("RowId are not supported");
    }

    @Override
    public int getHoldability() {
        return 1;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return (NClob)this.rowDecoder.decode(ClobCodec.INSTANCE, null, this.rowBuf, this.fieldLength, this.metadataList, this.fieldIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw this.exceptionFactory.notSupported("Method ResultSet.getSQLXML not supported");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw this.exceptionFactory.notSupported("Method ResultSet.getSQLXML not supported");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw this.exceptionFactory.notSupported("Method ResultSet.updateSQLXML not supported");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw this.exceptionFactory.notSupported("Method ResultSet.updateSQLXML not supported");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        if (this.fieldLength.get() == -1) {
            return null;
        }
        return this.rowDecoder.decode(ReaderCodec.INSTANCE, null, this.rowBuf, this.fieldLength, this.metadataList, this.fieldIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.checkIndex(columnIndex);
        this.fieldLength.set(this.rowDecoder.setPosition(columnIndex - 1, this.fieldIndex, this.maxIndex, this.rowBuf, this.nullBitmap, this.metadataList));
        Calendar calendar = null;
        if (this.wasNull()) {
            if (type.isPrimitive()) {
                throw new SQLException(String.format("Cannot return null for primitive %s", type.getName()));
            }
            return null;
        }
        Configuration conf = this.context.getConf();
        ColumnDecoder column = this.metadataList[columnIndex - 1];
        if (Object.class.equals(type) || type == null) {
            return (T)this.rowDecoder.defaultDecode(conf, this.metadataList, this.fieldIndex, this.rowBuf, this.fieldLength);
        }
        for (Codec<T> codec : conf.codecs()) {
            if (!codec.canDecode(column, type)) continue;
            return (T)this.rowDecoder.decode(codec, calendar, this.rowBuf, this.fieldLength, this.metadataList, this.fieldIndex);
        }
        this.rowBuf.skip(this.fieldLength.get());
        throw new SQLException(String.format("Type %s not supported type for %s type", type, column.getType().name()));
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException("The receiver is not a wrapper for " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        throw this.exceptionFactory.notSupported("Not supported when using CONCUR_READ_ONLY concurrency");
    }

    protected void setNullRowBuf() {
        this.rowBuf.buf(null, 0, 0);
    }

    @Override
    public int findColumn(String label) throws SQLException {
        Integer ind;
        if (label == null) {
            throw new SQLException("null is not a valid label value");
        }
        if (this.mapper == null) {
            this.mapper = new HashMap<String, Integer>();
            for (int i = 0; i < this.maxIndex; ++i) {
                ColumnDecoder ci = this.metadataList[i];
                String columnAlias = ci.getColumnAlias();
                if (columnAlias == null) continue;
                columnAlias = columnAlias.toLowerCase(Locale.ROOT);
                this.mapper.putIfAbsent(columnAlias, i + 1);
                String tableAlias = ci.getTableAlias();
                String tableLabel = tableAlias != null ? tableAlias : ci.getTable();
                this.mapper.putIfAbsent(tableLabel.toLowerCase(Locale.ROOT) + "." + columnAlias, i + 1);
            }
        }
        if ((ind = this.mapper.get(label.toLowerCase(Locale.ROOT))) == null) {
            String keys = Arrays.toString(this.mapper.keySet().toArray(new String[0]));
            throw new SQLException(String.format("Unknown label '%s'. Possible value %s", label, keys));
        }
        return ind;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        if (fetchSize < 0) {
            throw this.exceptionFactory.create(String.format("invalid fetch size %s", fetchSize));
        }
        this.fetchSize = fetchSize;
    }
}

