/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.message.client;

import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import net.skinsrestorer.shadow.mariadb.BasePreparedStatement;
import net.skinsrestorer.shadow.mariadb.ServerPreparedStatement;
import net.skinsrestorer.shadow.mariadb.Statement;
import net.skinsrestorer.shadow.mariadb.client.Completion;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.socket.Reader;
import net.skinsrestorer.shadow.mariadb.client.socket.Writer;
import net.skinsrestorer.shadow.mariadb.export.ExceptionFactory;
import net.skinsrestorer.shadow.mariadb.message.ClientMessage;
import net.skinsrestorer.shadow.mariadb.message.server.CachedPrepareResultPacket;
import net.skinsrestorer.shadow.mariadb.message.server.ErrorPacket;
import net.skinsrestorer.shadow.mariadb.message.server.PrepareResultPacket;

public final class PreparePacket
implements ClientMessage {
    private final String sql;

    public PreparePacket(String sql) {
        this.sql = sql;
    }

    @Override
    public int encode(Writer writer, Context context) throws IOException {
        writer.initPacket();
        writer.writeByte(22);
        writer.writeString(this.sql);
        writer.flush();
        return 1;
    }

    @Override
    public Completion readPacket(Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, Reader reader, Writer writer, Context context, ExceptionFactory exceptionFactory, ReentrantLock lock, boolean traceEnable, ClientMessage message) throws IOException, SQLException {
        ReadableByteBuf buf = reader.readReusablePacket(traceEnable);
        if (buf.getUnsignedByte() == 255) {
            ErrorPacket errorPacket = new ErrorPacket(buf, context);
            throw exceptionFactory.withSql(this.description()).create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
        }
        if (context.getConf().useServerPrepStmts() && context.getConf().cachePrepStmts() && this.sql.length() < 8192) {
            CachedPrepareResultPacket prepare = new CachedPrepareResultPacket(buf, reader, context);
            PrepareResultPacket previousCached = (PrepareResultPacket)context.getPrepareCache().put(this.sql, prepare, stmt instanceof ServerPreparedStatement ? (ServerPreparedStatement)stmt : null);
            if (stmt != null) {
                ((BasePreparedStatement)stmt).setPrepareResult(previousCached != null ? previousCached : prepare);
            }
            return previousCached != null ? previousCached : prepare;
        }
        PrepareResultPacket prepareResult = new PrepareResultPacket(buf, reader, context);
        if (stmt != null) {
            ((BasePreparedStatement)stmt).setPrepareResult(prepareResult);
        }
        return prepareResult;
    }

    @Override
    public String description() {
        return "PREPARE " + this.sql;
    }
}

