/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.message.server;

import net.skinsrestorer.shadow.mariadb.client.Completion;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.util.log.Logger;
import net.skinsrestorer.shadow.mariadb.util.log.Loggers;

public class OkPacket
implements Completion {
    private static final Logger logger = Loggers.getLogger(OkPacket.class);
    private final long affectedRows;
    private final long lastInsertId;

    public OkPacket(ReadableByteBuf buf, Context context) {
        buf.skip();
        this.affectedRows = buf.readLongLengthEncodedNotNull();
        this.lastInsertId = buf.readLongLengthEncodedNotNull();
        context.setServerStatus(buf.readUnsignedShort());
        context.setWarning(buf.readUnsignedShort());
        if (buf.readableBytes() > 0 && context.hasClientCapability(0x800000L)) {
            buf.skip(buf.readIntLengthEncodedNotNull());
            while (buf.readableBytes() > 0) {
                ReadableByteBuf sessionStateBuf = buf.readLengthBuffer();
                block15: while (sessionStateBuf.readableBytes() > 0) {
                    switch (sessionStateBuf.readByte()) {
                        case 0: {
                            ReadableByteBuf tmpBufsv;
                            do {
                                tmpBufsv = sessionStateBuf.readLengthBuffer();
                                String variableSv = tmpBufsv.readString(tmpBufsv.readIntLengthEncodedNotNull());
                                Integer lenSv = tmpBufsv.readLength();
                                String valueSv = lenSv == null ? null : tmpBufsv.readString(lenSv);
                                logger.debug("System variable change:  {} = {}", variableSv, valueSv);
                                switch (variableSv) {
                                    case "character_set_client": {
                                        context.setCharset(valueSv);
                                        break;
                                    }
                                    case "connection_id": {
                                        context.setThreadId(Long.parseLong(valueSv));
                                        break;
                                    }
                                    case "threads_Connected": {
                                        context.setTreadsConnected(Long.parseLong(valueSv));
                                    }
                                }
                            } while (tmpBufsv.readableBytes() > 0);
                            continue block15;
                        }
                        case 1: {
                            sessionStateBuf.readIntLengthEncodedNotNull();
                            Integer dbLen = sessionStateBuf.readLength();
                            String database = dbLen == null ? null : sessionStateBuf.readString(dbLen);
                            context.setDatabase(database.isEmpty() ? null : database);
                            logger.debug("Database change: is '{}'", database);
                            continue block15;
                        }
                    }
                }
            }
        }
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public long getLastInsertId() {
        return this.lastInsertId;
    }
}

