/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.plugin.codec;

import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;
import net.skinsrestorer.shadow.mariadb.client.ColumnDecoder;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.DataType;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.socket.Writer;
import net.skinsrestorer.shadow.mariadb.client.util.MutableInt;
import net.skinsrestorer.shadow.mariadb.plugin.Codec;
import net.skinsrestorer.shadow.mariadb.type.Geometry;
import net.skinsrestorer.shadow.mariadb.type.LineString;
import net.skinsrestorer.shadow.mariadb.type.MultiPolygon;
import net.skinsrestorer.shadow.mariadb.type.Point;
import net.skinsrestorer.shadow.mariadb.type.Polygon;

public class MultiPolygonCodec
implements Codec<MultiPolygon> {
    public static final MultiPolygonCodec INSTANCE = new MultiPolygonCodec();

    @Override
    public String className() {
        return MultiPolygon.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return column.getType() == DataType.GEOMETRY && type.isAssignableFrom(MultiPolygon.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof MultiPolygon;
    }

    @Override
    public MultiPolygon decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return this.decodeBinary(buf, length, column, cal);
    }

    @Override
    public MultiPolygon decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        if (column.getType() == DataType.GEOMETRY) {
            buf.skip(4);
            Geometry geo = Geometry.getGeometry(buf, length.get() - 4, column);
            if (geo instanceof MultiPolygon) {
                return (MultiPolygon)geo;
            }
            throw new SQLDataException(String.format("Geometric type %s cannot be decoded as MultiPolygon", geo.getClass().getName()));
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as MultiPolygon", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeBytes(("ST_MPolyFromText('" + value.toString() + "')").getBytes());
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        MultiPolygon mariadbMultiPolygon = (MultiPolygon)value;
        int length = 13;
        for (Polygon poly : mariadbMultiPolygon.getPolygons()) {
            length += 9;
            for (LineString ls : poly.getLines()) {
                length += 4 + ls.getPoints().length * 16;
            }
        }
        encoder.writeLength(length);
        encoder.writeInt(0);
        encoder.writeByte(1);
        encoder.writeInt(6);
        encoder.writeInt(mariadbMultiPolygon.getPolygons().length);
        for (Polygon poly : mariadbMultiPolygon.getPolygons()) {
            encoder.writeByte(1);
            encoder.writeInt(3);
            encoder.writeInt(poly.getLines().length);
            for (LineString ls : poly.getLines()) {
                encoder.writeInt(ls.getPoints().length);
                for (Point pt : ls.getPoints()) {
                    encoder.writeDouble(pt.getX());
                    encoder.writeDouble(pt.getY());
                }
            }
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BLOB.get();
    }
}

