/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.plugin.codec;

import java.io.IOException;
import java.sql.SQLDataException;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.EnumSet;
import net.skinsrestorer.shadow.mariadb.client.ColumnDecoder;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.DataType;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.socket.Writer;
import net.skinsrestorer.shadow.mariadb.client.util.MutableInt;
import net.skinsrestorer.shadow.mariadb.plugin.Codec;
import net.skinsrestorer.shadow.mariadb.plugin.codec.LocalDateTimeCodec;

public class OffsetDateTimeCodec
implements Codec<OffsetDateTime> {
    public static final OffsetDateTimeCodec INSTANCE = new OffsetDateTimeCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.DATETIME, new DataType[]{DataType.DATE, DataType.YEAR, DataType.TIMESTAMP, DataType.VARSTRING, DataType.VARCHAR, DataType.STRING, DataType.TIME, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return OffsetDateTime.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(OffsetDateTime.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof OffsetDateTime;
    }

    @Override
    public OffsetDateTime decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar calParam) throws SQLDataException {
        switch (column.getType()) {
            case DATETIME: 
            case TIMESTAMP: {
                LocalDateTime localDateTime = LocalDateTimeCodec.INSTANCE.decodeText(buf, length, column, calParam);
                if (localDateTime == null) {
                    return null;
                }
                Calendar cal = calParam == null ? Calendar.getInstance() : calParam;
                return localDateTime.atZone(cal.getTimeZone().toZoneId()).toOffsetDateTime();
            }
            case STRING: 
            case VARCHAR: 
            case VARSTRING: {
                String val = buf.readString(length.get());
                try {
                    return OffsetDateTime.parse(val);
                }
                catch (Throwable throwable) {
                    throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as OffsetDateTime", new Object[]{val, column.getType()}));
                }
            }
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("value of type %s cannot be decoded as OffsetDateTime", new Object[]{column.getType()}));
    }

    @Override
    public OffsetDateTime decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar calParam) throws SQLDataException {
        switch (column.getType()) {
            case DATETIME: 
            case TIMESTAMP: {
                LocalDateTime localDateTime = LocalDateTimeCodec.INSTANCE.decodeBinary(buf, length, column, calParam);
                if (localDateTime == null) {
                    return null;
                }
                Calendar cal = calParam == null ? Calendar.getInstance() : calParam;
                return localDateTime.atZone(cal.getTimeZone().toZoneId()).toOffsetDateTime();
            }
            case STRING: 
            case VARCHAR: 
            case VARSTRING: {
                String val = buf.readString(length.get());
                try {
                    return OffsetDateTime.parse(val);
                }
                catch (Throwable throwable) {
                    throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as OffsetDateTime", new Object[]{val, column.getType()}));
                }
            }
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("value of type %s cannot be decoded as OffsetDateTime", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object val, Calendar calParam, Long maxLen) throws IOException {
        OffsetDateTime zdt = (OffsetDateTime)val;
        Calendar cal = calParam == null ? Calendar.getInstance() : calParam;
        encoder.writeByte(39);
        encoder.writeAscii(zdt.atZoneSameInstant(cal.getTimeZone().toZoneId()).format(zdt.getNano() != 0 ? LocalDateTimeCodec.TIMESTAMP_FORMAT : LocalDateTimeCodec.TIMESTAMP_FORMAT_NO_FRACTIONAL));
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar calParam, Long maxLength) throws IOException {
        OffsetDateTime zdt = (OffsetDateTime)value;
        Calendar cal = calParam == null ? Calendar.getInstance() : calParam;
        ZonedDateTime convertedZdt = zdt.atZoneSameInstant(cal.getTimeZone().toZoneId());
        int nano = convertedZdt.getNano();
        if (nano > 0) {
            encoder.writeByte(11);
            encoder.writeShort((short)convertedZdt.getYear());
            encoder.writeByte(convertedZdt.getMonthValue());
            encoder.writeByte(convertedZdt.getDayOfMonth());
            encoder.writeByte(convertedZdt.getHour());
            encoder.writeByte(convertedZdt.getMinute());
            encoder.writeByte(convertedZdt.getSecond());
            encoder.writeInt(nano / 1000);
        } else {
            encoder.writeByte(7);
            encoder.writeShort((short)convertedZdt.getYear());
            encoder.writeByte(convertedZdt.getMonthValue());
            encoder.writeByte(convertedZdt.getDayOfMonth());
            encoder.writeByte(convertedZdt.getHour());
            encoder.writeByte(convertedZdt.getMinute());
            encoder.writeByte(convertedZdt.getSecond());
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.DATETIME.get();
    }
}

