/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.api;

import java.util.Optional;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.property.SkinApplier;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.storage.PlayerStorage;
import net.skinsrestorer.api.storage.SkinStorage;
import net.skinsrestorer.shared.api.PlatformWrapper;
import net.skinsrestorer.shared.api.SkinApplierAccess;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.utils.SRConstants;

public class SharedSkinApplier<P>
implements SkinApplier<P> {
    private final Class<P> playerClass;
    private final SkinApplierAccess<P> access;
    private final PlatformWrapper<P> wrapper;
    private final PlayerStorage playerStorage;
    private final SkinStorage skinStorage;

    public boolean accepts(Class<?> playerClass) {
        return this.playerClass.isAssignableFrom(playerClass);
    }

    @Override
    public void applySkin(P player) throws DataRequestException {
        SRPlayer srPlayer = this.wrapper.convert(player);
        Optional<SkinProperty> playerSkin = this.playerStorage.getSkinForPlayer(srPlayer.getUniqueId(), srPlayer.getName());
        this.applySkin(player, playerSkin.orElse(SRConstants.EMPTY_SKIN));
    }

    @Override
    public void applySkin(P player, SkinIdentifier identifier) {
        this.skinStorage.getSkinDataByIdentifier(identifier).ifPresent(property -> this.applySkin(player, (SkinProperty)property));
    }

    @Override
    public void applySkin(P player, SkinProperty property) {
        this.access.applySkin(player, property);
    }

    public SharedSkinApplier(Class<P> playerClass, SkinApplierAccess<P> access, PlatformWrapper<P> wrapper, PlayerStorage playerStorage, SkinStorage skinStorage) {
        this.playerClass = playerClass;
        this.access = access;
        this.wrapper = wrapper;
        this.playerStorage = playerStorage;
        this.skinStorage = skinStorage;
    }
}

