/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.api.event;

import java.lang.ref.WeakReference;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.skinsrestorer.api.event.EventBus;
import net.skinsrestorer.api.event.SkinsRestorerEvent;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.api.event.EventSubscription;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;

public class EventBusImpl
implements EventBus {
    private final Queue<EventSubscription<?>> subscriptions = new ConcurrentLinkedQueue();
    private final SRPlatformAdapter<Object> platformAdapter;

    @Override
    public <E extends SkinsRestorerEvent> void subscribe(Object plugin, Class<E> eventClass, Consumer<E> listener) {
        this.platformAdapter.extendLifeTime(plugin, listener);
        this.subscriptions.add(new EventSubscription<E>(new WeakReference<Object>(plugin), eventClass, new WeakReference<Consumer<E>>(listener)));
    }

    public void callEvent(SkinsRestorerEvent event) {
        this.subscriptions.removeIf(subscription -> subscription.getPlugin().get() == null || subscription.getListener().get() == null);
        for (EventSubscription eventSubscription : this.subscriptions) {
            Consumer listener;
            if (!eventSubscription.getEventClass().isAssignableFrom(event.getClass()) || (listener = (Consumer)eventSubscription.getListener().get()) == null) continue;
            try {
                listener.accept(event);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Inject
    public EventBusImpl(SRPlatformAdapter<Object> platformAdapter) {
        this.platformAdapter = platformAdapter;
    }
}

