/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands;

import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.skinsrestorer.shared.commands.library.annotations.CommandConditions;
import net.skinsrestorer.shared.commands.library.annotations.CommandNames;
import net.skinsrestorer.shared.commands.library.annotations.CommandPermission;
import net.skinsrestorer.shared.commands.library.annotations.Description;
import net.skinsrestorer.shared.commands.library.annotations.RootCommand;
import net.skinsrestorer.shared.plugin.SRProxyPlugin;
import net.skinsrestorer.shared.storage.SkinStorageImpl;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.SRProxyPlayer;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.permissions.PermissionRegistry;

@CommandNames(value={"skins"})
@Description(value=Message.HELP_SKINS)
@CommandPermission(value=PermissionRegistry.SKINS)
@CommandConditions(value={"cooldown", "allowed-server"})
public final class ProxyGUICommand {
    private final SkinStorageImpl skinStorage;
    private final SRProxyPlugin proxyPlugin;

    @RootCommand
    private void onDefault(SRPlayer player) {
        if (!(player instanceof SRProxyPlayer)) {
            throw new IllegalStateException("Player is not a proxy player");
        }
        player.sendMessage(Message.SKINSMENU_OPEN, new TagResolver[0]);
        this.proxyPlugin.sendPage(0, (SRProxyPlayer)player, this.skinStorage);
    }

    @Inject
    public ProxyGUICommand(SkinStorageImpl skinStorage, SRProxyPlugin proxyPlugin) {
        this.skinStorage = skinStorage;
        this.proxyPlugin = proxyPlugin;
    }
}

