/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.skinsrestorer.api.PropertyUtils;
import net.skinsrestorer.api.SkinsRestorer;
import net.skinsrestorer.api.connections.MineSkinAPI;
import net.skinsrestorer.api.connections.model.MineSkinResponse;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.exception.MineSkinException;
import net.skinsrestorer.api.model.MojangProfileResponse;
import net.skinsrestorer.api.property.InputDataResult;
import net.skinsrestorer.api.property.SkinApplier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.api.storage.CacheStorage;
import net.skinsrestorer.api.storage.PlayerStorage;
import net.skinsrestorer.builddata.BuildData;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.skinsrestorer.shared.commands.library.CommandManager;
import net.skinsrestorer.shared.commands.library.annotations.CommandConditions;
import net.skinsrestorer.shared.commands.library.annotations.CommandNames;
import net.skinsrestorer.shared.commands.library.annotations.CommandPermission;
import net.skinsrestorer.shared.commands.library.annotations.Description;
import net.skinsrestorer.shared.commands.library.annotations.RootCommand;
import net.skinsrestorer.shared.commands.library.annotations.Subcommand;
import net.skinsrestorer.shared.config.DevConfig;
import net.skinsrestorer.shared.connections.DumpService;
import net.skinsrestorer.shared.connections.ServiceCheckerService;
import net.skinsrestorer.shared.exception.InitializeException;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.plugin.SRServerPlugin;
import net.skinsrestorer.shared.storage.SkinStorageImpl;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.subjects.permissions.PermissionRegistry;
import net.skinsrestorer.shared.utils.ComponentHelper;
import net.skinsrestorer.shared.utils.ValidationUtil;

@CommandNames(value={"sr", "skinsrestorer"})
@Description(value=Message.HELP_SR)
@CommandPermission(value=PermissionRegistry.SR)
@CommandConditions(value={"allowed-server"})
public final class SRCommand {
    private final SRPlugin plugin;
    private final SRPlatformAdapter<?> adapter;
    private final ServiceCheckerService serviceCheckerService;
    private final PlayerStorage playerStorage;
    private final CacheStorage cacheStorage;
    private final SkinStorageImpl skinStorage;
    private final SettingsManager settings;
    private final SRLogger logger;
    private final DumpService dumpService;
    private final SkinsRestorer skinsRestorer;
    private final MineSkinAPI mineSkinAPI;
    private final SkinApplier<Object> skinApplier;
    private final Injector injector;
    private final SkinsRestorerLocale locale;
    private final CommandManager<SRCommandSender> commandManager;

    @RootCommand
    private void onDefault(SRCommandSender sender) {
        this.commandManager.getHelpMessage("sr", sender).forEach(sender::sendMessage);
    }

    @Subcommand(value={"reload"})
    @CommandPermission(value=PermissionRegistry.SR_RELOAD)
    @Description(value=Message.HELP_SR_RELOAD)
    private void onReload(SRCommandSender sender) {
        this.plugin.loadConfig();
        try {
            this.plugin.loadLocales();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.plugin.loadStorage();
        }
        catch (InitializeException e) {
            e.printStackTrace();
        }
        sender.sendMessage(Message.SUCCESS_ADMIN_RELOAD, new TagResolver[0]);
    }

    @Subcommand(value={"status"})
    @CommandPermission(value=PermissionRegistry.SR_STATUS)
    @Description(value=Message.HELP_SR_STATUS)
    private void onStatus(SRCommandSender sender) {
        sender.sendMessage(Message.ADMINCOMMAND_STATUS_CHECKING, new TagResolver[0]);
        String breakLine = ComponentHelper.parseMiniMessageToJsonString("<dark_aqua>----------------------------------------------");
        sender.sendMessage(breakLine);
        ServiceCheckerService.ServiceCheckResponse response = this.serviceCheckerService.checkServices();
        List<String> results = response.getResults();
        int workingUUIDCount = response.getWorkingUUID();
        int workingProfileCount = response.getWorkingProfile();
        if (this.settings.getProperty(DevConfig.DEBUG).booleanValue() || workingUUIDCount == 0 || workingProfileCount == 0) {
            for (String result : results) {
                if (!this.settings.getProperty(DevConfig.DEBUG).booleanValue() && !result.contains("\u2718")) continue;
                sender.sendMessage(ComponentHelper.parseMiniMessageToJsonString(result));
            }
        }
        sender.sendMessage(Message.ADMINCOMMAND_STATUS_WORKING_COUNT, Placeholder.unparsed("count", String.valueOf(workingUUIDCount)));
        sender.sendMessage(Message.ADMINCOMMAND_STATUS_WORKING_COUNT, Placeholder.unparsed("count", String.valueOf(workingProfileCount)));
        if (workingUUIDCount != 0 && workingProfileCount != 0) {
            sender.sendMessage(Message.ADMINCOMMAND_STATUS_WORKING, new TagResolver[0]);
        } else {
            sender.sendMessage(Message.ADMINCOMMAND_STATUS_BROKEN, new TagResolver[0]);
        }
        sender.sendMessage(breakLine);
        sender.sendMessage(Message.ADMINCOMMAND_STATUS_SUMMARY_VERSION, Placeholder.unparsed("version", this.plugin.getVersion()));
        sender.sendMessage(Message.ADMINCOMMAND_STATUS_SUMMARY_SERVER, Placeholder.unparsed("version", this.adapter.getPlatformVersion()));
        SRServerPlugin serverPlugin = this.injector.getIfAvailable(SRServerPlugin.class);
        if (serverPlugin != null) {
            sender.sendMessage(Message.ADMINCOMMAND_STATUS_SUMMARY_PROXYMODE, Placeholder.unparsed("proxy_mode", Boolean.toString(serverPlugin.isProxyMode())));
        }
        sender.sendMessage(Message.ADMINCOMMAND_STATUS_SUMMARY_COMMIT, Placeholder.unparsed("hash", BuildData.COMMIT_SHORT));
        sender.sendMessage(Message.ADMINCOMMAND_STATUS_SUMMARY_FINISHED, new TagResolver[0]);
        sender.sendMessage(breakLine);
    }

    @Subcommand(value={"drop", "remove"})
    @CommandPermission(value=PermissionRegistry.SR_DROP)
    @Description(value=Message.HELP_SR_DROP)
    private void onDrop(SRCommandSender sender, PlayerOrSkin playerOrSkin, String target) {
        switch (playerOrSkin) {
            case PLAYER: {
                try {
                    Optional<UUID> targetId = this.cacheStorage.getUUID(target, false);
                    if (!targetId.isPresent()) {
                        sender.sendMessage(Message.ADMINCOMMAND_DROP_PLAYER_NOT_FOUND, Placeholder.unparsed("player", target));
                        return;
                    }
                    this.playerStorage.removeSkinIdOfPlayer(targetId.get());
                    break;
                }
                catch (DataRequestException e) {
                    sender.sendMessage(Message.ADMINCOMMAND_DROP_UUID_ERROR, new TagResolver[0]);
                    return;
                }
            }
            case SKIN: {
                Optional<InputDataResult> optional = this.skinStorage.findSkinData(target);
                if (!optional.isPresent()) {
                    sender.sendMessage(Message.ADMINCOMMAND_DROP_SKIN_NOT_FOUND, Placeholder.unparsed("skin", target));
                    return;
                }
                InputDataResult result = optional.get();
                this.skinStorage.removeSkinData(result.getIdentifier());
            }
        }
        sender.sendMessage(Message.SUCCESS_ADMIN_DROP, Placeholder.unparsed("type", playerOrSkin.toString()), Placeholder.unparsed("target", target));
    }

    @Subcommand(value={"props"})
    @CommandPermission(value=PermissionRegistry.SR_PROPS)
    @Description(value=Message.HELP_SR_PROPS)
    private void onProps(SRCommandSender sender, SRPlayer target) {
        try {
            Optional<SkinProperty> properties = this.adapter.getSkinProperty(target);
            if (!properties.isPresent()) {
                sender.sendMessage(Message.NO_SKIN_DATA, new TagResolver[0]);
                return;
            }
            MojangProfileResponse profile = PropertyUtils.getSkinProfileData(properties.get());
            String decodedSkin = profile.getTextures().getSKIN().getUrl();
            long timestamp = profile.getTimestamp();
            String requestTime = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date(timestamp));
            sender.sendMessage(Message.ADMINCOMMAND_PROPS_REQUEST_TIME, Placeholder.unparsed("request_time", requestTime));
            sender.sendMessage(Message.ADMINCOMMAND_PROPS_PROFILE_ID, Placeholder.unparsed("profile_id", profile.getProfileId()));
            sender.sendMessage(Message.ADMINCOMMAND_PROPS_NAME, Placeholder.unparsed("profile_name", profile.getProfileName()));
            sender.sendMessage(Message.ADMINCOMMAND_PROPS_SKIN_TEXTURE, Placeholder.unparsed("skin_texture", decodedSkin));
            sender.sendMessage(Message.ADMINCOMMAND_PROPS_MORE_INFO_IN_CONSOLE, new TagResolver[0]);
            this.logger.info("\u00a7aValue: \u00a78" + properties.get().getValue());
            this.logger.info("\u00a7aSignature: \u00a78" + properties.get().getSignature());
            this.logger.info("\u00a7aValue Decoded: \u00a7e" + profile);
        }
        catch (Exception e) {
            e.printStackTrace();
            sender.sendMessage(Message.NO_SKIN_DATA, new TagResolver[0]);
        }
    }

    @Subcommand(value={"applyskin"})
    @CommandPermission(value=PermissionRegistry.SR_APPLY_SKIN)
    @Description(value=Message.HELP_SR_APPLY_SKIN)
    private void onApplySkin(SRCommandSender sender, SRPlayer target) {
        try {
            this.skinApplier.applySkin(target.getAs(Object.class));
            sender.sendMessage(Message.SUCCESS_ADMIN_APPLYSKIN, new TagResolver[0]);
        }
        catch (DataRequestException e) {
            ComponentHelper.sendException(e, sender, this.locale, this.logger);
        }
    }

    @Subcommand(value={"createcustom"})
    @CommandPermission(value=PermissionRegistry.SR_CREATE_CUSTOM)
    @Description(value=Message.HELP_SR_CREATE_CUSTOM)
    private void onCreateCustom(SRCommandSender sender, String skinName, String skinUrl, SkinVariant skinVariant) {
        try {
            if (ValidationUtil.validSkinUrl(skinUrl)) {
                MineSkinResponse response = this.mineSkinAPI.genSkin(skinUrl, skinVariant);
                this.skinStorage.setCustomSkinData(skinName, response.getProperty());
                sender.sendMessage(Message.SUCCESS_ADMIN_CREATECUSTOM, Placeholder.unparsed("skin", skinName));
            } else {
                sender.sendMessage(Message.ERROR_INVALID_URLSKIN, new TagResolver[0]);
            }
        }
        catch (DataRequestException | MineSkinException e) {
            ComponentHelper.sendException(e, sender, this.locale, this.logger);
        }
    }

    @Subcommand(value={"setskinall"})
    @CommandPermission(value=PermissionRegistry.SR_CREATE_CUSTOM)
    @Description(value=Message.HELP_SR_SET_SKIN_ALL)
    @CommandConditions(value={"console-only"})
    private void onSetSkinAll(SRCommandSender sender, String skinName, SkinVariant skinVariant) {
        Optional<InputDataResult> optional = this.skinStorage.findSkinData(skinName);
        if (!optional.isPresent()) {
            sender.sendMessage(Message.ADMINCOMMAND_SETSKINALL_NOT_FOUND, new TagResolver[0]);
            return;
        }
        for (SRPlayer player : this.adapter.getOnlinePlayers()) {
            this.playerStorage.setSkinIdOfPlayer(player.getUniqueId(), optional.get().getIdentifier());
            this.skinApplier.applySkin(player.getAs(Object.class), optional.get().getProperty());
        }
        sender.sendMessage(Message.ADMINCOMMAND_SETSKINALL_SUCCESS, Placeholder.unparsed("skin", skinName));
    }

    @Subcommand(value={"applyskinall"})
    @CommandPermission(value=PermissionRegistry.SR_APPLY_SKIN_ALL)
    @Description(value=Message.HELP_SR_APPLY_SKIN_ALL)
    @CommandConditions(value={"console-only"})
    private void onApplySkinAll(SRCommandSender sender) {
        for (SRPlayer player : this.adapter.getOnlinePlayers()) {
            try {
                this.skinApplier.applySkin(player.getAs(Object.class));
            }
            catch (DataRequestException ignored) {
                sender.sendMessage(Message.ADMINCOMMAND_APPLYSKINALL_PLAYER_ERROR, Placeholder.unparsed("player", player.getName()));
            }
        }
        sender.sendMessage(Message.ADMINCOMMAND_APPLYSKINALL_SUCCESS, new TagResolver[0]);
    }

    @Subcommand(value={"purgeolddata"})
    @CommandPermission(value=PermissionRegistry.SR_PURGE_OLD_DATA)
    @Description(value=Message.HELP_SR_PURGE_OLD_DATA)
    @CommandConditions(value={"console-only"})
    private void onPurgeOldData(SRCommandSender sender, int days) {
        if (this.skinStorage.purgeOldSkins(days)) {
            sender.sendMessage(Message.ADMINCOMMAND_PURGEOLDDATA_SUCCESS, new TagResolver[0]);
        } else {
            sender.sendMessage(Message.ADMINCOMMAND_PURGEOLDDATA_ERROR, new TagResolver[0]);
        }
    }

    @Subcommand(value={"dump"})
    @CommandPermission(value=PermissionRegistry.SR_DUMP)
    @Description(value=Message.HELP_SR_DUMP)
    private void onDump(SRCommandSender sender) {
        try {
            sender.sendMessage(Message.ADMINCOMMAND_DUMP_UPLOADING, new TagResolver[0]);
            Optional<String> url = this.dumpService.dump();
            if (url.isPresent()) {
                sender.sendMessage(Message.ADMINCOMMAND_DUMP_SUCCESS, Placeholder.unparsed("url", "https://bytebin.lucko.me/" + url.get()));
            } else {
                sender.sendMessage(Message.ADMINCOMMAND_DUMP_ERROR, new TagResolver[0]);
            }
        }
        catch (IOException | DataRequestException e) {
            sender.sendMessage(Message.ADMINCOMMAND_DUMP_ERROR, new TagResolver[0]);
            e.printStackTrace();
        }
    }

    @Inject
    public SRCommand(SRPlugin plugin, SRPlatformAdapter<?> adapter, ServiceCheckerService serviceCheckerService, PlayerStorage playerStorage, CacheStorage cacheStorage, SkinStorageImpl skinStorage, SettingsManager settings, SRLogger logger, DumpService dumpService, SkinsRestorer skinsRestorer, MineSkinAPI mineSkinAPI, SkinApplier<Object> skinApplier, Injector injector, SkinsRestorerLocale locale, CommandManager<SRCommandSender> commandManager) {
        this.plugin = plugin;
        this.adapter = adapter;
        this.serviceCheckerService = serviceCheckerService;
        this.playerStorage = playerStorage;
        this.cacheStorage = cacheStorage;
        this.skinStorage = skinStorage;
        this.settings = settings;
        this.logger = logger;
        this.dumpService = dumpService;
        this.skinsRestorer = skinsRestorer;
        this.mineSkinAPI = mineSkinAPI;
        this.skinApplier = skinApplier;
        this.injector = injector;
        this.locale = locale;
        this.commandManager = commandManager;
    }

    public static enum PlayerOrSkin {
        PLAYER,
        SKIN;

    }
}

