/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands.library.types;

import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.skinsrestorer.shadow.brigadier.LiteralMessage;
import net.skinsrestorer.shadow.brigadier.StringReader;
import net.skinsrestorer.shadow.brigadier.arguments.ArgumentType;
import net.skinsrestorer.shadow.brigadier.context.CommandContext;
import net.skinsrestorer.shadow.brigadier.exceptions.CommandSyntaxException;
import net.skinsrestorer.shadow.brigadier.exceptions.SimpleCommandExceptionType;
import net.skinsrestorer.shadow.brigadier.suggestion.Suggestions;
import net.skinsrestorer.shadow.brigadier.suggestion.SuggestionsBuilder;

public class EnumArgumentType
implements ArgumentType<Enum<?>> {
    private final Class<?> enumType;

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        for (String example : this.getExamples()) {
            if (!example.startsWith(builder.getRemaining().toUpperCase(Locale.ROOT))) continue;
            builder.suggest(example);
        }
        return builder.buildFuture();
    }

    @Override
    public Collection<String> getExamples() {
        return Arrays.stream(this.enumType.getEnumConstants()).map(o -> (Enum)o).map(Enum::name).collect(Collectors.toList());
    }

    @Override
    public Enum<?> parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        String string = reader.readString();
        try {
            return Enum.valueOf(this.enumType, string.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            reader.setCursor(start);
            throw new SimpleCommandExceptionType(new LiteralMessage("Invalid enum value")).createWithContext(reader);
        }
    }

    public EnumArgumentType(Class<?> enumType) {
        this.enumType = enumType;
    }
}

