/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.config;

import java.util.Locale;
import net.skinsrestorer.shadow.configme.Comment;
import net.skinsrestorer.shadow.configme.SettingsHolder;
import net.skinsrestorer.shadow.configme.configurationdata.CommentsConfiguration;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.configme.properties.PropertyInitializer;
import net.skinsrestorer.shadow.configme.properties.TypeBasedProperty;
import net.skinsrestorer.shared.config.LocaleProperty;

public class MessageConfig
implements SettingsHolder {
    @Comment(value={"A locale code for the locale you want to use by default for messages and commands.", "Has to be a string separated by an underscore."})
    public static final Property<Locale> LOCALE = new TypeBasedProperty<Locale>("messages.locale", Locale.ENGLISH, LocaleProperty.instance());
    @Comment(value={"A locale code for the messages and commands sent to the console.", "This is useful if you want to use a different locale for the console than for players.", "We recommend keeping this at the default value because we mostly only provide support in English.", "Has to be a string separated by an underscore."})
    public static final Property<Locale> CONSOLE_LOCALE = new TypeBasedProperty<Locale>("messages.consoleLocale", Locale.ENGLISH, LocaleProperty.instance());
    @Comment(value={"Disable the message prefix in SkinsRestorer messages."})
    public static final Property<Boolean> DISABLE_PREFIX = PropertyInitializer.newProperty("messages.disablePrefix", false);
    @Comment(value={"Every message sent by the plugin will use the players client locale if a translation is available.", "If disabled, the config locale will be used instead."})
    public static final Property<Boolean> PER_ISSUER_LOCALE = PropertyInitializer.newProperty("messages.perIssuerLocale", true);

    @Override
    public void registerComments(CommentsConfiguration conf) {
        conf.setComment("messages", "\n", "\n##########", "\n# Locale #", "\n##########", "\n", "Translation & message options here", "To learn more about translations and how to make custom translations, visit: https://skinsrestorer.net/docs/configuration/locale-translations");
    }
}

