/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.config;

import java.util.List;
import net.skinsrestorer.shadow.configme.Comment;
import net.skinsrestorer.shadow.configme.SettingsHolder;
import net.skinsrestorer.shadow.configme.configurationdata.CommentsConfiguration;
import net.skinsrestorer.shadow.configme.properties.ListProperty;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.configme.properties.PropertyInitializer;
import net.skinsrestorer.shadow.configme.properties.convertresult.ConvertErrorRecorder;
import net.skinsrestorer.shadow.configme.properties.types.PropertyType;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shared.utils.FluentList;

public class StorageConfig
implements SettingsHolder {
    public static final Property<Boolean> DEFAULT_SKINS_ENABLED = PropertyInitializer.newProperty("storage.defaultSkins.enabled", false);
    public static final Property<Boolean> DEFAULT_SKINS_PREMIUM = PropertyInitializer.newProperty("storage.defaultSkins.applyForPremium", false);
    public static final Property<List<String>> DEFAULT_SKINS = new ListProperty<String>("storage.defaultSkins.list", new PropertyType<String>(){

        @Override
        @Nullable
        public String convert(@Nullable Object object, @NotNull ConvertErrorRecorder errorRecorder) {
            return object == null ? null : object.toString().replace(".skin", "");
        }

        @Override
        @Nullable
        public Object toExportValue(String value) {
            return value;
        }
    }, FluentList.of("xknat", "pistonmaster"));
    @Comment(value={"<!! Warning !!>", "Enable this will require players to run \"/skin update\" to update their skin."})
    public static final Property<Boolean> DISALLOW_AUTO_UPDATE_SKIN = PropertyInitializer.newProperty("storage.disallowAutoUpdateSkin", false);
    @Comment(value={"Time that skins are stored in the database before we request again (in minutes).", "[?] A value of 0 will disable auto updating of skins and players will need to manual run /skin update.", "[!] Lowering this value will increase the amount of requests which could be a problem on large servers."})
    public static final Property<Integer> SKIN_EXPIRES_AFTER = PropertyInitializer.newProperty("storage.skinExpiresAfter", 15);
    @Comment(value={"How long we should cache the UUIDs of players (in minutes)."})
    public static final Property<Integer> UUID_EXPIRES_AFTER = PropertyInitializer.newProperty("storage.uuidExpiresAfter", 60);

    @Override
    public void registerComments(CommentsConfiguration conf) {
        conf.setComment("storage", "\n", "\n###########", "\n# Storage #", "\n###########", "\n", "Here you can design the plugin the way you want it.", "\n", "Enable or disable default skins", "applyForPremium: false will only put a skin on skinless/steve players.", "If there is more than one, the plugin will choose a random one.", "[?] Supports custom & url.png skins, read SkinFile Generator below. [?]");
    }
}

