/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.connections;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Optional;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.shadow.google.gson.Gson;
import net.skinsrestorer.shadow.google.gson.GsonBuilder;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.connections.http.HttpClient;
import net.skinsrestorer.shared.connections.http.HttpResponse;
import net.skinsrestorer.shared.connections.requests.DumpInfo;
import net.skinsrestorer.shared.connections.responses.BytebinResponse;
import net.skinsrestorer.shared.info.EnvironmentInfo;
import net.skinsrestorer.shared.info.PlatformInfo;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.plugin.SRServerPlugin;

public class DumpService {
    private static final URI BYTEBIN_ENDPOINT = URI.create("https://bytebin.lucko.me/post");
    private final SRLogger logger;
    private final SRPlugin plugin;
    private final SRPlatformAdapter<?> adapter;
    private final Injector injector;
    private final HttpClient httpClient;
    private final Gson gson = new GsonBuilder().serializeNulls().create();

    public Optional<String> dump() throws IOException, DataRequestException {
        SRServerPlugin serverPlugin = this.injector.getIfAvailable(SRServerPlugin.class);
        Boolean proxyMode = serverPlugin == null ? null : Boolean.valueOf(serverPlugin.isProxyMode());
        EnvironmentInfo environmentInfo = EnvironmentInfo.determineEnvironment(this.adapter);
        PlatformInfo platformInfo = new PlatformInfo(this.adapter.getPlatformName(), this.adapter.getPlatformVendor(), this.adapter.getPlatformVersion(), this.adapter.getPlugins());
        DumpInfo dumpInfo = new DumpInfo(this.plugin.getVersion(), proxyMode, environmentInfo, platformInfo, new DumpInfo.OSInfo(), new DumpInfo.JavaInfo(), new DumpInfo.UserInfo());
        HttpResponse response = this.httpClient.execute(BYTEBIN_ENDPOINT, new HttpClient.RequestBody(this.gson.toJson(dumpInfo), HttpClient.HttpType.JSON), HttpClient.HttpType.JSON, this.plugin.getUserAgent(), HttpClient.HttpMethod.POST, Collections.emptyMap(), 20000);
        if (response.getStatusCode() != 201) {
            this.logger.warning("Failed to dump data to bytebin. Response code: " + response.getStatusCode());
            return Optional.empty();
        }
        BytebinResponse responseObject = response.getBodyAs(BytebinResponse.class);
        return Optional.of(responseObject.getKey());
    }

    @Inject
    public DumpService(SRLogger logger, SRPlugin plugin, SRPlatformAdapter<?> adapter, Injector injector, HttpClient httpClient) {
        this.logger = logger;
        this.plugin = plugin;
        this.adapter = adapter;
        this.injector = injector;
        this.httpClient = httpClient;
    }
}

