/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.connections;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import net.skinsrestorer.api.connections.MojangAPI;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.property.MojangSkinDataResult;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.connections.http.HttpClient;
import net.skinsrestorer.shared.connections.http.HttpResponse;
import net.skinsrestorer.shared.connections.responses.AshconResponse;
import net.skinsrestorer.shared.connections.responses.profile.MineToolsProfileResponse;
import net.skinsrestorer.shared.connections.responses.profile.MojangProfileResponse;
import net.skinsrestorer.shared.connections.responses.profile.PropertyResponse;
import net.skinsrestorer.shared.connections.responses.uuid.MineToolsUUIDResponse;
import net.skinsrestorer.shared.connections.responses.uuid.MojangUUIDResponse;
import net.skinsrestorer.shared.exception.DataRequestExceptionShared;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.utils.MetricsCounter;
import net.skinsrestorer.shared.utils.UUIDUtils;
import net.skinsrestorer.shared.utils.ValidationUtil;

public class MojangAPIImpl
implements MojangAPI {
    private static final String ASHCON = "https://api.ashcon.app/mojang/v2/user/%uuidOrName%";
    private static final String UUID_MOJANG = "https://api.mojang.com/users/profiles/minecraft/%playerName%";
    private static final String UUID_MINETOOLS = "https://api.minetools.eu/uuid/%playerName%";
    private static final String PROFILE_MOJANG = "https://sessionserver.mojang.com/session/minecraft/profile/%uuid%?unsigned=false";
    private static final String PROFILE_MINETOOLS = "https://api.minetools.eu/profile/%uuid%";
    private final MetricsCounter metricsCounter;
    private final SRLogger logger;
    private final SRPlugin plugin;
    private final HttpClient httpClient;

    @Override
    public Optional<MojangSkinDataResult> getSkin(String playerName) throws DataRequestException {
        if (ValidationUtil.invalidMojangUsername(playerName)) {
            return Optional.empty();
        }
        try {
            return this.getDataAshcon(playerName);
        }
        catch (DataRequestException e) {
            this.logger.debug(e);
            Optional<UUID> uuidResult = this.getUUIDStartMojang(playerName);
            if (!uuidResult.isPresent()) {
                return Optional.empty();
            }
            return this.getProfileStartMojang(uuidResult.get()).flatMap(propertyResponse -> Optional.of(MojangSkinDataResult.of((UUID)uuidResult.get(), propertyResponse)));
        }
    }

    @Override
    public Optional<UUID> getUUID(String playerName) throws DataRequestException {
        if (ValidationUtil.invalidMojangUsername(playerName)) {
            return Optional.empty();
        }
        try {
            return this.getDataAshcon(playerName).map(MojangSkinDataResult::getUniqueId);
        }
        catch (DataRequestException e) {
            this.logger.debug(e);
            return this.getUUIDStartMojang(playerName);
        }
    }

    private Optional<UUID> getUUIDStartMojang(String playerName) throws DataRequestException {
        try {
            return this.getUUIDMojang(playerName);
        }
        catch (DataRequestException e) {
            this.logger.debug(e);
            return this.getUUIDMineTools(playerName);
        }
    }

    protected Optional<MojangSkinDataResult> getDataAshcon(String uuidOrName) throws DataRequestException {
        HttpResponse httpResponse = this.readURL(URI.create(ASHCON.replace("%uuidOrName%", uuidOrName)), MetricsCounter.Service.ASHCON);
        AshconResponse response = httpResponse.getBodyAs(AshconResponse.class);
        if (response.getCode() == 404) {
            return Optional.empty();
        }
        if (response.getError() != null) {
            throw new DataRequestExceptionShared("Ashcon error: " + response.getError());
        }
        if (response.getCode() != 0) {
            throw new DataRequestExceptionShared("Ashcon error code: " + response.getCode());
        }
        if (response.getUuid() == null) {
            return Optional.empty();
        }
        AshconResponse.Textures textures = response.getTextures();
        if (textures == null) {
            return Optional.empty();
        }
        AshconResponse.Textures.Raw rawTextures = textures.getRaw();
        if (rawTextures == null) {
            return Optional.empty();
        }
        if (rawTextures.getValue().isEmpty() || rawTextures.getSignature().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(MojangSkinDataResult.of(UUID.fromString(response.getUuid()), SkinProperty.of(rawTextures.getValue(), rawTextures.getSignature())));
    }

    public Optional<UUID> getUUIDMojang(String playerName) throws DataRequestException {
        HttpResponse httpResponse = this.readURL(URI.create(UUID_MOJANG.replace("%playerName%", playerName)), MetricsCounter.Service.MOJANG);
        if (httpResponse.getStatusCode() == 204 || httpResponse.getStatusCode() == 404 || httpResponse.getBody().isEmpty()) {
            return Optional.empty();
        }
        MojangUUIDResponse response = httpResponse.getBodyAs(MojangUUIDResponse.class);
        if (response.getError() != null) {
            throw new DataRequestExceptionShared("Mojang error: " + response.getError());
        }
        return Optional.ofNullable(response.getId()).map(UUIDUtils::convertToDashed);
    }

    protected Optional<UUID> getUUIDMineTools(String playerName) throws DataRequestException {
        HttpResponse httpResponse = this.readURL(URI.create(UUID_MINETOOLS.replace("%playerName%", playerName)), MetricsCounter.Service.MINE_TOOLS, 10000);
        MineToolsUUIDResponse response = httpResponse.getBodyAs(MineToolsUUIDResponse.class);
        if (response.getStatus() != null && response.getStatus().equals("ERR")) {
            throw new DataRequestExceptionShared("MineTools error: " + response.getStatus());
        }
        return Optional.ofNullable(response.getId()).map(UUIDUtils::convertToDashed);
    }

    @Override
    public Optional<SkinProperty> getProfile(UUID uuid) throws DataRequestException {
        try {
            return this.getDataAshcon(uuid.toString().replace("-", "")).map(MojangSkinDataResult::getSkinProperty);
        }
        catch (DataRequestException e) {
            this.logger.debug(e);
            return this.getProfileStartMojang(uuid);
        }
    }

    private Optional<SkinProperty> getProfileStartMojang(UUID uuid) throws DataRequestException {
        try {
            return this.getProfileMojang(uuid);
        }
        catch (DataRequestException e) {
            this.logger.debug(e);
            return this.getProfileMineTools(uuid);
        }
    }

    public Optional<SkinProperty> getProfileMojang(UUID uuid) throws DataRequestException {
        HttpResponse httpResponse = this.readURL(URI.create(PROFILE_MOJANG.replace("%uuid%", UUIDUtils.convertToNoDashes(uuid))), MetricsCounter.Service.MOJANG);
        MojangProfileResponse response = httpResponse.getBodyAs(MojangProfileResponse.class);
        if (response.getProperties() == null) {
            return Optional.empty();
        }
        PropertyResponse property = response.getProperties()[0];
        if (property.getValue().isEmpty() || property.getSignature().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SkinProperty.of(property.getValue(), property.getSignature()));
    }

    protected Optional<SkinProperty> getProfileMineTools(UUID uuid) throws DataRequestException {
        HttpResponse httpResponse = this.readURL(URI.create(PROFILE_MINETOOLS.replace("%uuid%", UUIDUtils.convertToNoDashes(uuid))), MetricsCounter.Service.MINE_TOOLS, 10000);
        MineToolsProfileResponse response = httpResponse.getBodyAs(MineToolsProfileResponse.class);
        if (response.getRaw() == null) {
            return Optional.empty();
        }
        MineToolsProfileResponse.Raw raw = response.getRaw();
        if (raw.getStatus() != null && raw.getStatus().equals("ERR")) {
            throw new DataRequestExceptionShared("MineTools error: " + raw.getStatus());
        }
        PropertyResponse property = raw.getProperties()[0];
        if (property.getValue().isEmpty() || property.getSignature().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SkinProperty.of(property.getValue(), property.getSignature()));
    }

    private HttpResponse readURL(URI uri, MetricsCounter.Service service) throws DataRequestException {
        return this.readURL(uri, service, 5000);
    }

    private HttpResponse readURL(URI uri, MetricsCounter.Service service, int timeout) throws DataRequestException {
        this.metricsCounter.increment(service);
        try {
            return this.httpClient.execute(uri, null, HttpClient.HttpType.JSON, this.plugin.getUserAgent(), HttpClient.HttpMethod.GET, Collections.emptyMap(), timeout);
        }
        catch (IOException e) {
            this.logger.debug("Error while reading URL: " + uri, e);
            throw new DataRequestExceptionShared(e);
        }
    }

    @Inject
    public MojangAPIImpl(MetricsCounter metricsCounter, SRLogger logger, SRPlugin plugin, HttpClient httpClient) {
        this.metricsCounter = metricsCounter;
        this.logger = logger;
        this.plugin = plugin;
        this.httpClient = httpClient;
    }
}

