/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.connections;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.property.MojangSkinDataResult;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.connections.MojangAPIImpl;

public class ServiceCheckerService {
    private static final String XKNAT_NAME = "xknat";
    private static final UUID XKNAT_UUID = UUID.fromString("7dcfc130-344a-4719-9fbe-3176bc2075c6");
    private static final String MESSAGE_ERROR = "%s <red>\u2718 Error getting %s";
    private static final String MESSAGE_ERROR_EXCEPTION = "%s <red>\u2718 Error getting %s: %s";
    private static final String UUID_MESSAGE = "%s <green>\u2714 xknat UUID: <aqua>%s";
    private static final String PROFILE_MESSAGE = "%s <green>\u2714 xknat Profile: <aqua>%s";
    private final MojangAPIImpl mojangAPI;

    public ServiceCheckResponse checkServices() {
        Optional<UUID> uuid;
        ServiceCheckResponse response = new ServiceCheckResponse();
        try {
            Optional<MojangSkinDataResult> uuidAshcon = this.mojangAPI.getDataAshcon(XKNAT_NAME);
            if (uuidAshcon.isPresent()) {
                response.addResult(String.format(PROFILE_MESSAGE, "Ashcon", uuidAshcon.get().getUniqueId()));
                response.incrementWorkingUUID();
            } else {
                response.addResult(String.format(MESSAGE_ERROR, "Ashcon", "UUID"));
            }
        }
        catch (DataRequestException e) {
            response.addResult(String.format(MESSAGE_ERROR_EXCEPTION, "Ashcon", "UUID", e.getMessage()));
        }
        try {
            uuid = this.mojangAPI.getUUIDMojang(XKNAT_NAME);
            if (uuid.isPresent()) {
                response.addResult(String.format(UUID_MESSAGE, "Mojang", uuid.get()));
                response.incrementWorkingUUID();
            } else {
                response.addResult(String.format(MESSAGE_ERROR, "Mojang", "UUID"));
            }
        }
        catch (DataRequestException e) {
            response.addResult(String.format(MESSAGE_ERROR_EXCEPTION, "Mojang", "UUID", e.getMessage()));
        }
        try {
            uuid = this.mojangAPI.getUUIDMineTools(XKNAT_NAME);
            if (uuid.isPresent()) {
                response.addResult(String.format(UUID_MESSAGE, "MineTools", uuid.get()));
                response.incrementWorkingUUID();
            } else {
                response.addResult(String.format(MESSAGE_ERROR, "MineTools", "UUID"));
            }
        }
        catch (DataRequestException e) {
            response.addResult(String.format(MESSAGE_ERROR_EXCEPTION, "MineTools", "UUID", e.getMessage()));
        }
        try {
            Optional<MojangSkinDataResult> nameAshcon = this.mojangAPI.getDataAshcon(XKNAT_UUID.toString());
            if (nameAshcon.isPresent()) {
                response.addResult(String.format(PROFILE_MESSAGE, "Ashcon", nameAshcon.get().getSkinProperty()));
                response.incrementWorkingProfile();
            } else {
                response.addResult(String.format(MESSAGE_ERROR, "Ashcon", "Profile"));
            }
        }
        catch (DataRequestException e) {
            response.addResult(String.format(MESSAGE_ERROR_EXCEPTION, "Ashcon", "Profile", e.getMessage()));
        }
        try {
            Optional<SkinProperty> mojang = this.mojangAPI.getProfileMojang(XKNAT_UUID);
            if (mojang.isPresent()) {
                response.addResult(String.format(PROFILE_MESSAGE, "Mojang", mojang.get()));
                response.incrementWorkingProfile();
            } else {
                response.addResult(String.format(MESSAGE_ERROR, "Mojang", "Profile"));
            }
        }
        catch (DataRequestException e) {
            response.addResult(String.format(MESSAGE_ERROR_EXCEPTION, "Mojang", "Profile", e.getMessage()));
        }
        try {
            Optional<SkinProperty> minetools = this.mojangAPI.getProfileMineTools(XKNAT_UUID);
            if (minetools.isPresent()) {
                response.addResult(String.format(PROFILE_MESSAGE, "MineTools", minetools.get()));
                response.incrementWorkingProfile();
            } else {
                response.addResult(String.format(MESSAGE_ERROR, "MineTools", "Profile"));
            }
        }
        catch (DataRequestException e) {
            response.addResult(String.format(MESSAGE_ERROR_EXCEPTION, "MineTools", "Profile", e.getMessage()));
        }
        return response;
    }

    @Inject
    public ServiceCheckerService(MojangAPIImpl mojangAPI) {
        this.mojangAPI = mojangAPI;
    }

    public static class ServiceCheckResponse {
        private final List<String> results = new LinkedList<String>();
        private int workingUUID = 0;
        private int workingProfile = 0;

        private void addResult(String result) {
            this.results.add(result);
        }

        private void incrementWorkingUUID() {
            ++this.workingUUID;
        }

        private void incrementWorkingProfile() {
            ++this.workingProfile;
        }

        public List<String> getResults() {
            return this.results;
        }

        public int getWorkingUUID() {
            return this.workingUUID;
        }

        public int getWorkingProfile() {
            return this.workingProfile;
        }
    }
}

