/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.connections.http;

import java.util.List;
import java.util.Map;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.shadow.google.gson.Gson;
import net.skinsrestorer.shadow.google.gson.JsonSyntaxException;
import net.skinsrestorer.shared.exception.DataRequestExceptionShared;

public class HttpResponse {
    private static final Gson GSON = new Gson();
    private final int statusCode;
    private final String body;
    private final Map<String, List<String>> headers;

    public <T> T getBodyAs(Class<T> clazz) throws DataRequestException {
        try {
            return GSON.fromJson(this.body, clazz);
        }
        catch (JsonSyntaxException e) {
            throw new DataRequestExceptionShared(e);
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public HttpResponse(int statusCode, String body, Map<String, List<String>> headers) {
        this.statusCode = statusCode;
        this.body = body;
        this.headers = headers;
    }
}

