/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.floodgate;

import java.util.Optional;
import java.util.function.Consumer;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.storage.PlayerStorage;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.log.SRLogger;
import org.geysermc.floodgate.api.event.skin.SkinApplyEvent;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateListener
implements Consumer<SkinApplyEvent> {
    private final SRLogger logger;
    private final PlayerStorage playerStorage;

    @Override
    public void accept(SkinApplyEvent event) {
        FloodgatePlayer floodgatePlayer = event.player();
        this.logger.debug("Handling Floodgate skin apply for " + floodgatePlayer.getCorrectUsername() + " (" + floodgatePlayer.getCorrectUniqueId() + ")");
        try {
            Optional<SkinProperty> optional = this.playerStorage.getSkinForPlayer(floodgatePlayer.getCorrectUniqueId(), floodgatePlayer.getCorrectUsername(), true);
            optional.ifPresent(skinProperty -> event.newSkin((SkinApplyEvent.SkinData)new SkinDataImpl(skinProperty.getValue(), skinProperty.getSignature())));
        }
        catch (DataRequestException e) {
            this.logger.warning("Failed to get skin for " + floodgatePlayer.getCorrectUsername() + " (" + floodgatePlayer.getCorrectUniqueId() + ")", e);
        }
    }

    @Inject
    public FloodgateListener(SRLogger logger, PlayerStorage playerStorage) {
        this.logger = logger;
        this.playerStorage = playerStorage;
    }

    private static class SkinDataImpl
    implements SkinApplyEvent.SkinData {
        private final String value;
        private final String signature;

        public String value() {
            return this.value;
        }

        public String signature() {
            return this.signature;
        }

        public SkinDataImpl(String value, String signature) {
            this.value = value;
            this.signature = signature;
        }
    }
}

