/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.listeners;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Optional;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.commands.library.CommandManager;
import net.skinsrestorer.shared.listeners.event.SRProxyMessageEvent;
import net.skinsrestorer.shared.plugin.SRProxyAdapter;
import net.skinsrestorer.shared.plugin.SRProxyPlugin;
import net.skinsrestorer.shared.storage.SkinStorageImpl;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRProxyPlayer;

public final class SRProxyMessageAdapter {
    private final SkinStorageImpl skinStorage;
    private final SRProxyAdapter<?> plugin;
    private final CommandManager<SRCommandSender> commandManager;
    private final SRProxyPlugin proxyPlugin;

    public void handlePluginMessage(SRProxyMessageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getChannel().equals("sr:messagechannel")) {
            return;
        }
        if (!event.isServerConnection()) {
            event.setCancelled(true);
            return;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(event.getData()));
        try {
            String subChannel = in.readUTF();
            Optional<SRProxyPlayer> optional = this.plugin.getPlayer(in.readUTF());
            if (!optional.isPresent()) {
                return;
            }
            SRProxyPlayer player = optional.get();
            switch (subChannel) {
                case "getSkins": {
                    int page = Math.min(in.readInt(), 999);
                    this.proxyPlugin.sendPage(page, player, this.skinStorage);
                    break;
                }
                case "clearSkin": {
                    this.commandManager.executeCommand(player, "skin clear");
                    break;
                }
                case "setSkin": {
                    String skin = in.readUTF();
                    this.commandManager.executeCommand(player, "skin set " + skin);
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Inject
    public SRProxyMessageAdapter(SkinStorageImpl skinStorage, SRProxyAdapter<?> plugin, CommandManager<SRCommandSender> commandManager, SRProxyPlugin proxyPlugin) {
        this.skinStorage = skinStorage;
        this.plugin = plugin;
        this.commandManager = commandManager;
        this.proxyPlugin = proxyPlugin;
    }
}

