/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.log;

import net.skinsrestorer.shared.log.ANSIConverter;
import net.skinsrestorer.shared.log.SRLogLevel;
import net.skinsrestorer.shared.log.SRPlatformLogger;

public class SRLogger {
    private final SRPlatformLogger logger;
    private final boolean color;
    private boolean debug = false;

    public void debug(String message) {
        this.debug(SRLogLevel.INFO, message);
    }

    public void debug(String message, Throwable thrown) {
        this.debug(SRLogLevel.WARNING, message, thrown);
    }

    public void debug(Throwable thrown) {
        this.debug(SRLogLevel.WARNING, "Received error", thrown);
    }

    public void debug(SRLogLevel level, String message) {
        if (!this.debug) {
            return;
        }
        this.log(level, message);
    }

    public void debug(SRLogLevel level, String message, Throwable thrown) {
        if (!this.debug) {
            return;
        }
        this.log(level, message, thrown);
    }

    public void info(String message) {
        this.log(SRLogLevel.INFO, message);
    }

    public void info(String message, Throwable thrown) {
        this.log(SRLogLevel.INFO, message, thrown);
    }

    public void warning(String message) {
        this.log(SRLogLevel.WARNING, message);
    }

    public void warning(String message, Throwable thrown) {
        this.log(SRLogLevel.WARNING, message, thrown);
    }

    public void severe(String message) {
        this.log(SRLogLevel.SEVERE, message);
    }

    public void severe(String message, Throwable thrown) {
        this.log(SRLogLevel.SEVERE, message, thrown);
    }

    private void log(SRLogLevel level, String message) {
        this.logger.log(level, this.formatMessage(message));
    }

    private void log(SRLogLevel level, String message, Throwable thrown) {
        this.logger.log(level, this.formatMessage(message), thrown);
    }

    private String formatMessage(String message) {
        message = this.color ? "\u00a7e[\u00a72SkinsRestorer\u00a7e] \u00a7r" + message : message;
        message = message + "\u00a7r";
        message = ANSIConverter.convertToAnsi(message);
        return message;
    }

    public SRLogger(SRPlatformLogger logger, boolean color) {
        this.logger = logger;
        this.color = color;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

