/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.plugin;

import java.nio.file.Path;
import java.util.function.Consumer;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.injector.InjectorBuilder;
import net.skinsrestorer.shared.log.SRLogLevel;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.log.SRPlatformLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRPlatformInit;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.plugin.SRProxyAdapter;
import net.skinsrestorer.shared.plugin.SRServerAdapter;
import net.skinsrestorer.shared.update.UpdateCheckInit;

public class SRBootstrapper {
    public static void startPlugin(Consumer<Runnable> shutdownHookConsumer, Consumer<Injector> platformRegister, SRPlatformLogger isrLogger, boolean loggerColor, Class<? extends SRPlatformAdapter<?>> adapterClass, Class<?> srPlatformClass, String version, Path dataFolder, Class<? extends SRPlatformInit> initCLass) {
        SRPlugin srPlugin;
        block8: {
            srPlugin = null;
            try {
                Injector injector = new InjectorBuilder().addDefaultHandlers("net.skinsrestorer").create();
                platformRegister.accept(injector);
                injector.register(SRLogger.class, new SRLogger(isrLogger, loggerColor));
                SRPlatformAdapter<?> adapter = injector.getSingleton(adapterClass);
                injector.register(SRPlatformAdapter.class, adapter);
                if (adapter instanceof SRServerAdapter) {
                    injector.register(SRServerAdapter.class, (SRServerAdapter)adapter);
                } else if (adapter instanceof SRProxyAdapter) {
                    injector.register(SRProxyAdapter.class, (SRProxyAdapter)adapter);
                }
                srPlugin = new SRPlugin(injector, version, dataFolder);
                injector.getSingleton(srPlatformClass);
                shutdownHookConsumer.accept(srPlugin::shutdown);
                srPlugin.startup(initCLass);
            }
            catch (Throwable t) {
                isrLogger.log(SRLogLevel.SEVERE, "An unexpected error occurred while starting the plugin. Please check the console for more details.", t);
                if (!SRPlugin.isUnitTest()) break block8;
                throw new AssertionError((Object)t);
            }
        }
        if (srPlugin != null && !srPlugin.isUpdaterInitialized()) {
            isrLogger.log(SRLogLevel.WARNING, "Updater was not initialized, a error occurred while starting the plugin. Forcing updater to initialize.");
            try {
                srPlugin.initUpdateCheck(UpdateCheckInit.InitCause.ERROR);
            }
            catch (Throwable t) {
                isrLogger.log(SRLogLevel.SEVERE, "An unexpected error occurred while initializing the updater. Please check the console for more details.", t);
            }
        }
    }
}

