/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.plugin;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.skinsrestorer.api.SkinsRestorer;
import net.skinsrestorer.api.SkinsRestorerProvider;
import net.skinsrestorer.api.connections.MineSkinAPI;
import net.skinsrestorer.api.connections.MojangAPI;
import net.skinsrestorer.api.property.SkinApplier;
import net.skinsrestorer.api.storage.CacheStorage;
import net.skinsrestorer.api.storage.PlayerStorage;
import net.skinsrestorer.api.storage.SkinStorage;
import net.skinsrestorer.shadow.bstats.MetricsBase;
import net.skinsrestorer.shadow.bstats.charts.SimplePie;
import net.skinsrestorer.shadow.bstats.charts.SingleLineChart;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.configme.SettingsManagerBuilder;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.skinsrestorer.shared.api.PlatformWrapper;
import net.skinsrestorer.shared.api.SharedSkinApplier;
import net.skinsrestorer.shared.api.SharedSkinsRestorer;
import net.skinsrestorer.shared.api.SkinApplierAccess;
import net.skinsrestorer.shared.api.event.EventBusImpl;
import net.skinsrestorer.shared.commands.ProxyGUICommand;
import net.skinsrestorer.shared.commands.SRCommand;
import net.skinsrestorer.shared.commands.ServerGUICommand;
import net.skinsrestorer.shared.commands.SkinCommand;
import net.skinsrestorer.shared.commands.library.CommandManager;
import net.skinsrestorer.shared.config.APIConfig;
import net.skinsrestorer.shared.config.AdvancedConfig;
import net.skinsrestorer.shared.config.CommandConfig;
import net.skinsrestorer.shared.config.CommentsConfig;
import net.skinsrestorer.shared.config.ConfigMigratorService;
import net.skinsrestorer.shared.config.DatabaseConfig;
import net.skinsrestorer.shared.config.DevConfig;
import net.skinsrestorer.shared.config.GUIConfig;
import net.skinsrestorer.shared.config.LoginConfig;
import net.skinsrestorer.shared.config.MessageConfig;
import net.skinsrestorer.shared.config.ProxyConfig;
import net.skinsrestorer.shared.config.ServerConfig;
import net.skinsrestorer.shared.config.StorageConfig;
import net.skinsrestorer.shared.connections.MineSkinAPIImpl;
import net.skinsrestorer.shared.connections.MojangAPIImpl;
import net.skinsrestorer.shared.connections.ServiceCheckerService;
import net.skinsrestorer.shared.exception.InitializeException;
import net.skinsrestorer.shared.floodgate.FloodgateUtil;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRPlatformInit;
import net.skinsrestorer.shared.plugin.SRProxyPlatformInit;
import net.skinsrestorer.shared.plugin.SRProxyPlugin;
import net.skinsrestorer.shared.plugin.SRServerPlatformInit;
import net.skinsrestorer.shared.plugin.SRServerPlugin;
import net.skinsrestorer.shared.storage.CacheStorageImpl;
import net.skinsrestorer.shared.storage.CooldownStorage;
import net.skinsrestorer.shared.storage.PlayerStorageImpl;
import net.skinsrestorer.shared.storage.SkinStorageImpl;
import net.skinsrestorer.shared.storage.adapter.AdapterReference;
import net.skinsrestorer.shared.storage.adapter.file.FileAdapter;
import net.skinsrestorer.shared.storage.adapter.mysql.MySQLAdapter;
import net.skinsrestorer.shared.storage.adapter.mysql.MySQLProvider;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.SRProxyPlayer;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.MessageLoader;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.subjects.permissions.PermissionRegistry;
import net.skinsrestorer.shared.update.UpdateCheckInit;
import net.skinsrestorer.shared.utils.MetricsCounter;
import net.skinsrestorer.shared.utils.ReflectionUtil;
import net.skinsrestorer.shared.utils.SRFileUtils;

public class SRPlugin {
    private static final String USER_AGENT = "SkinsRestorer/%s (%s)";
    private static final boolean unitTest = System.getProperty("sr.unit.test") != null;
    private final SRPlatformAdapter<?> adapter;
    private final SRLogger logger;
    private final Path dataFolder;
    private final String version;
    private final Injector injector;
    private final List<Runnable> shutdownHooks = new ArrayList<Runnable>();
    private boolean outdated = false;
    private boolean updaterInitialized = false;

    public SRPlugin(Injector injector, String version, Path dataFolder) {
        injector.register(SRPlugin.class, this);
        this.injector = injector;
        this.adapter = injector.getSingleton(SRPlatformAdapter.class);
        this.logger = injector.getSingleton(SRLogger.class);
        this.version = version;
        this.dataFolder = dataFolder;
    }

    public void initCommands() {
        CommandManager<SRCommandSender> manager = new CommandManager<SRCommandSender>(this.adapter, this.logger, this.injector.getSingleton(SkinsRestorerLocale.class), this.injector.getSingleton(SettingsManager.class));
        this.injector.register(CommandManager.class, manager);
        this.registerConditions(manager);
        this.adapter.runRepeatAsync(this.injector.getSingleton(CooldownStorage.class)::cleanup, 60, 60, TimeUnit.SECONDS);
        manager.registerCommand(this.injector.newInstance(SRCommand.class));
        SettingsManager settings = this.injector.getSingleton(SettingsManager.class);
        if (!settings.getProperty(CommandConfig.DISABLE_SKIN_COMMAND).booleanValue()) {
            manager.registerCommand(this.injector.newInstance(SkinCommand.class));
        }
        if (!settings.getProperty(CommandConfig.DISABLE_GUI_COMMAND).booleanValue()) {
            if (this.injector.getIfAvailable(SRServerPlugin.class) != null) {
                manager.registerCommand(this.injector.newInstance(ServerGUICommand.class));
            } else if (this.injector.getIfAvailable(SRProxyPlugin.class) != null) {
                manager.registerCommand(this.injector.newInstance(ProxyGUICommand.class));
            } else {
                throw new IllegalStateException("Unknown platform");
            }
        }
    }

    private void registerConditions(CommandManager<SRCommandSender> manager) {
        SettingsManager settings = this.injector.getSingleton(SettingsManager.class);
        CooldownStorage cooldownStorage = this.injector.getSingleton(CooldownStorage.class);
        manager.registerCondition("allowed-server", sender -> {
            boolean shouldBlock;
            if (!(sender instanceof SRProxyPlayer)) {
                return true;
            }
            if (!settings.getProperty(ProxyConfig.NOT_ALLOWED_COMMAND_SERVERS_ENABLED).booleanValue()) {
                return true;
            }
            Optional<String> optional = ((SRProxyPlayer)sender).getCurrentServer();
            if (!optional.isPresent()) {
                if (!settings.getProperty(ProxyConfig.NOT_ALLOWED_COMMAND_SERVERS_IF_NONE_BLOCK_COMMAND).booleanValue()) {
                    sender.sendMessage(Message.NOT_CONNECTED_TO_SERVER, new TagResolver[0]);
                    return false;
                }
                return true;
            }
            String server = optional.get();
            boolean inList = settings.getProperty(ProxyConfig.NOT_ALLOWED_COMMAND_SERVERS).contains(server);
            boolean bl = shouldBlock = settings.getProperty(ProxyConfig.NOT_ALLOWED_COMMAND_SERVERS_ALLOWLIST) != inList;
            if (shouldBlock) {
                sender.sendMessage(Message.COMMAND_SERVER_NOT_ALLOWED_MESSAGE, Placeholder.unparsed("server", server));
                return false;
            }
            return true;
        });
        manager.registerCondition("cooldown", sender -> {
            if (sender instanceof SRPlayer) {
                UUID senderUUID = ((SRPlayer)sender).getUniqueId();
                if (!sender.hasPermission(PermissionRegistry.BYPASS_COOLDOWN) && cooldownStorage.hasCooldown(senderUUID)) {
                    sender.sendMessage(Message.SKIN_COOLDOWN, Placeholder.unparsed("time", String.valueOf(cooldownStorage.getCooldownSeconds(senderUUID))));
                    return false;
                }
            }
            return true;
        });
    }

    public void loadConfig() {
        SettingsManager settings = this.injector.getIfAvailable(SettingsManager.class);
        if (settings == null) {
            settings = SettingsManagerBuilder.withYamlFile(this.dataFolder.resolve("config.yml")).configurationData(CommentsConfig.class, MessageConfig.class, DatabaseConfig.class, CommandConfig.class, GUIConfig.class, StorageConfig.class, ProxyConfig.class, ServerConfig.class, LoginConfig.class, APIConfig.class, AdvancedConfig.class, DevConfig.class).migrationService(this.injector.getSingleton(ConfigMigratorService.class)).create();
            this.injector.register(SettingsManager.class, settings);
        } else {
            settings.reload();
        }
        this.logger.setDebug(settings.getProperty(DevConfig.DEBUG) != false || unitTest);
        this.revertSettings(settings);
    }

    private void revertSettings(SettingsManager settings) {
        if (settings.getProperty(StorageConfig.DEFAULT_SKINS_ENABLED).booleanValue() && settings.getProperty(StorageConfig.DEFAULT_SKINS).isEmpty()) {
            this.logger.warning("[Config] No DefaultSkins configured! Disabling DefaultSkins.");
            settings.setProperty(StorageConfig.DEFAULT_SKINS_ENABLED, false);
        }
        if (settings.getProperty(CommandConfig.DISABLED_SKINS_ENABLED).booleanValue() && settings.getProperty(CommandConfig.DISABLED_SKINS).isEmpty()) {
            this.logger.warning("[Config] No DisabledSkins configured! Disabling DisabledSkins.");
            settings.setProperty(CommandConfig.DISABLED_SKINS_ENABLED, false);
        }
        if (settings.getProperty(CommandConfig.RESTRICT_SKIN_URLS_ENABLED).booleanValue() && settings.getProperty(CommandConfig.RESTRICT_SKIN_URLS_LIST).isEmpty()) {
            this.logger.warning("[Config] No RestrictSkinUrls configured! Disabling RestrictSkinUrls.");
            settings.setProperty(CommandConfig.RESTRICT_SKIN_URLS_ENABLED, false);
        }
        if (!settings.getProperty(GUIConfig.CUSTOM_GUI_ENABLED).booleanValue()) {
            settings.setProperty(GUIConfig.CUSTOM_GUI_ONLY, false);
        }
        if (!settings.getProperty(ServerConfig.DISMOUNT_PLAYER_ON_UPDATE).booleanValue()) {
            settings.setProperty(ServerConfig.REMOUNT_PLAYER_ON_UPDATE, false);
        }
    }

    public void loadLocales() throws IOException {
        this.injector.getSingleton(MessageLoader.class).loadMessages();
    }

    public void moveOldFiles() {
        try {
            SRFileUtils.renameFile(this.dataFolder, "Archive", "archive");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.moveToArchive(this.dataFolder.resolve("messages.yml"));
        this.moveToArchive(this.dataFolder.resolve("command-messages.properties"));
        this.moveToArchive(this.dataFolder.resolve("command.properties"));
        this.moveToArchive(this.dataFolder.resolve("languages"));
    }

    public void moveToArchive(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        this.logger.info("Moving old file " + path.getFileName() + " to archive folder.");
        Path archive = this.dataFolder.resolve("archive");
        Path target = archive.resolve(path.getFileName().toString() + "_" + System.currentTimeMillis());
        try {
            Files.createDirectories(archive, new FileAttribute[0]);
            Files.move(path, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadStorage() throws InitializeException {
        SkinStorageImpl skinStorage = this.injector.getSingleton(SkinStorageImpl.class);
        SettingsManager settings = this.injector.getSingleton(SettingsManager.class);
        try {
            if (settings.getProperty(DatabaseConfig.MYSQL_ENABLED).booleanValue()) {
                MySQLProvider mySQLProvider = this.injector.getSingleton(MySQLProvider.class);
                mySQLProvider.initPool();
                MySQLAdapter adapter = this.injector.getSingleton(MySQLAdapter.class);
                adapter.init();
                this.logger.info("Connected to MySQL!");
                this.injector.getSingleton(AdapterReference.class).setAdapter(adapter);
            } else {
                this.injector.getSingleton(AdapterReference.class).setAdapter(this.injector.getSingleton(FileAdapter.class));
            }
            this.adapter.runAsync(skinStorage::preloadDefaultSkins);
        }
        catch (SQLException e) {
            this.logger.severe("\u00a7cCan't connect to MySQL! Disabling SkinsRestorer.", e);
            throw new InitializeException(e);
        }
    }

    public void initUpdateCheck(UpdateCheckInit.InitCause cause) {
        if (this.updaterInitialized) {
            return;
        }
        this.updaterInitialized = true;
        Path updaterDisabled = this.dataFolder.resolve("noupdate.txt");
        if (Files.exists(updaterDisabled, new LinkOption[0])) {
            this.logger.info("Updater Disabled");
            return;
        }
        this.injector.getSingleton(UpdateCheckInit.class).run(cause);
    }

    public void setOutdated() {
        this.outdated = true;
    }

    public void registerAPI() {
        SkinsRestorer api = this.injector.getSingleton(SharedSkinsRestorer.class);
        SkinsRestorerProvider.setApi(api);
        this.injector.register(SkinsRestorer.class, api);
    }

    public <P> void registerSkinApplier(SkinApplierAccess<P> skinApplier, Class<P> playerClass, PlatformWrapper<P> platformWrapper) {
        SharedSkinApplier<P> sharedSkinApplier = new SharedSkinApplier<P>(playerClass, skinApplier, platformWrapper, this.injector.getSingleton(PlayerStorageImpl.class), this.injector.getSingleton(SkinStorageImpl.class));
        this.injector.register(SharedSkinApplier.class, sharedSkinApplier);
        this.injector.register(SkinApplier.class, sharedSkinApplier);
    }

    public void registerMetrics(Object metricsParent) {
        MetricsCounter metricsCounter = this.injector.getSingleton(MetricsCounter.class);
        try {
            Field field = metricsParent.getClass().getDeclaredField("metricsBase");
            field.setAccessible(true);
            MetricsBase metrics = (MetricsBase)field.get(metricsParent);
            metrics.addCustomChart(new SingleLineChart("mineskin_calls", () -> metricsCounter.collect(MetricsCounter.Service.MINE_SKIN)));
            metrics.addCustomChart(new SingleLineChart("minetools_calls", () -> metricsCounter.collect(MetricsCounter.Service.MINE_TOOLS)));
            metrics.addCustomChart(new SingleLineChart("mojang_calls", () -> metricsCounter.collect(MetricsCounter.Service.MOJANG)));
            metrics.addCustomChart(new SingleLineChart("ashcon_calls", () -> metricsCounter.collect(MetricsCounter.Service.ASHCON)));
            metrics.addCustomChart(new SimplePie("uses_mysql", metricsCounter::usesMySQL));
            metrics.addCustomChart(new SimplePie("proxy_mode", metricsCounter::isProxyMode));
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public void startup(Class<? extends SRPlatformInit> initClass) throws InitializeException {
        SRServerPlugin serverPlugin = this.injector.getIfAvailable(SRServerPlugin.class);
        SRProxyPlugin proxyPlugin = this.injector.getIfAvailable(SRProxyPlugin.class);
        this.loadConfig();
        if (!unitTest) {
            this.registerMetrics(this.adapter.createMetricsInstance());
        }
        this.injector.getSingleton(EventBusImpl.class);
        if (serverPlugin != null) {
            serverPlugin.checkProxyMode();
        }
        try {
            this.moveOldFiles();
            this.loadLocales();
        }
        catch (IOException e) {
            throw new InitializeException(e);
        }
        this.injector.register(MineSkinAPI.class, this.injector.getSingleton(MineSkinAPIImpl.class));
        this.injector.register(MojangAPI.class, this.injector.getSingleton(MojangAPIImpl.class));
        this.injector.register(CacheStorage.class, this.injector.getSingleton(CacheStorageImpl.class));
        this.injector.register(SkinStorage.class, this.injector.getSingleton(SkinStorageImpl.class));
        this.injector.register(PlayerStorage.class, this.injector.getSingleton(PlayerStorageImpl.class));
        SRPlatformInit platformInit = this.injector.newInstance(initClass);
        platformInit.initSkinApplier();
        platformInit.checkPluginSupport();
        platformInit.prePlatformInit();
        if (serverPlugin != null) {
            serverPlugin.startupPlatform((SRServerPlatformInit)platformInit);
        } else if (proxyPlugin != null) {
            proxyPlugin.startupPlatform((SRProxyPlatformInit)platformInit);
        } else {
            throw new IllegalStateException("No platform class available!");
        }
        if (ReflectionUtil.classExists("org.geysermc.floodgate.api.FloodgateApi")) {
            FloodgateUtil.registerListener(this.injector);
        }
        this.initUpdateCheck(UpdateCheckInit.InitCause.STARTUP);
        if (serverPlugin == null || !serverPlugin.isProxyMode()) {
            this.adapter.runAsync(this::runServiceCheck);
        }
    }

    private void runServiceCheck() {
        ServiceCheckerService.ServiceCheckResponse response = this.injector.getSingleton(ServiceCheckerService.class).checkServices();
        if (response.getWorkingUUID() == 0 || response.getWorkingProfile() == 0) {
            this.logger.info("\u00a7c[\u00a74Critical\u00a7c] ------------------[\u00a72SkinsRestorer \u00a7cis \u00a7c\u00a7l\u00a7nOFFLINE\u00a7r\u00a7c] -------------------------");
            this.logger.info("\u00a7c[\u00a74Critical\u00a7c] \u00a7cPlugin currently can't fetch new skins due to blocked connection!");
            this.logger.info("\u00a7c[\u00a74Critical\u00a7c] \u00a7cSee https://skinsrestorer.net/firewall for steps to resolve your issue!");
            this.logger.info("\u00a7c[\u00a74Critical\u00a7c] ----------------------------------------------------------------------");
        }
    }

    public String getUserAgent() {
        return String.format(USER_AGENT, new Object[]{this.version, this.adapter.getPlatform()});
    }

    public void shutdown() {
        this.adapter.shutdownCleanup();
        this.shutdownHooks.forEach(Runnable::run);
    }

    public static boolean isUnitTest() {
        return unitTest;
    }

    public Path getDataFolder() {
        return this.dataFolder;
    }

    public String getVersion() {
        return this.version;
    }

    public List<Runnable> getShutdownHooks() {
        return this.shutdownHooks;
    }

    public boolean isOutdated() {
        return this.outdated;
    }

    public boolean isUpdaterInitialized() {
        return this.updaterInitialized;
    }
}

