/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.plugin;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shared.exception.InitializeException;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.plugin.SRProxyPlatformInit;
import net.skinsrestorer.shared.storage.SkinStorageImpl;
import net.skinsrestorer.shared.subjects.SRProxyPlayer;
import net.skinsrestorer.shared.utils.MessageProtocolUtil;

public class SRProxyPlugin {
    private final SRLogger logger;
    private final SRPlugin plugin;

    public void sendPage(int page, SRProxyPlayer player, SkinStorageImpl skinStorage) {
        int skinNumber = 36 * page;
        byte[] ba = MessageProtocolUtil.convertToByteArray(skinStorage.getGUISkins(skinNumber));
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            out.writeUTF("returnSkinsV3");
            out.writeUTF(player.getName());
            out.writeInt(page);
            out.writeShort(ba.length);
            out.write(ba);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        byte[] data = b.toByteArray();
        this.logger.debug(String.format("Sending skins to %s (%d bytes)", player.getName(), data.length));
        if (data.length > 32749) {
            this.logger.warning("Too many bytes GUI... canceling GUI..");
            return;
        }
        player.sendDataToServer("sr:messagechannel", data);
    }

    public void sendUpdateRequest(@NotNull SRProxyPlayer player, SkinProperty textures) {
        if (!player.getCurrentServer().isPresent()) {
            return;
        }
        this.logger.debug("Sending skin update request for " + player.getName());
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            out.writeUTF("SkinUpdateV2");
            if (textures != null) {
                out.writeUTF(textures.getValue());
                out.writeUTF(textures.getSignature());
            }
            player.sendDataToServer("sr:messagechannel", b.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startupPlatform(SRProxyPlatformInit init) throws InitializeException {
        this.plugin.loadStorage();
        this.plugin.registerAPI();
        init.initLoginProfileListener();
        init.initConnectListener();
        this.plugin.initCommands();
        init.initMessageChannel();
    }

    @Inject
    public SRProxyPlugin(SRLogger logger, SRPlugin plugin) {
        this.logger = logger;
        this.plugin = plugin;
    }
}

