/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.exception.InitializeException;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.plugin.SRServerAdapter;
import net.skinsrestorer.shared.plugin.SRServerPlatformInit;

public class SRServerPlugin {
    private final SRPlugin plugin;
    private final SRServerAdapter<?> serverAdapter;
    private final SRLogger logger;
    private boolean proxyMode;

    public void checkProxyMode() {
        block15: {
            this.proxyMode = this.checkProxy();
            try {
                Path warning = this.plugin.getDataFolder().resolve("(README) Use proxy config for settings! (README).txt");
                if (this.proxyMode) {
                    if (!Files.isDirectory(this.plugin.getDataFolder(), new LinkOption[0])) {
                        Files.createDirectories(this.plugin.getDataFolder(), new FileAttribute[0]);
                    }
                    try (InputStream inputStream = this.serverAdapter.getResource("proxy_warning.txt");){
                        if (inputStream == null) {
                            throw new IllegalStateException("Could not find proxy_warning.txt in resources!");
                        }
                        String proxyWarning = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                        if (Files.exists(warning, new LinkOption[0])) {
                            String existingWarning = new String(Files.readAllBytes(warning), StandardCharsets.UTF_8);
                            if (!existingWarning.equals(proxyWarning)) {
                                Files.write(warning, proxyWarning.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                            }
                        } else {
                            Files.copy(inputStream, warning, new CopyOption[0]);
                        }
                        break block15;
                    }
                }
                Files.deleteIfExists(warning);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.proxyMode) {
            this.logger.info("-------------------------/Warning\\-------------------------");
            this.logger.info("This plugin is running in PROXY mode!");
            this.logger.info("You have to do all configuration at config file");
            this.logger.info("inside your BungeeCord/Velocity server.");
            this.logger.info("(<proxy>/plugins/SkinsRestorer/)");
            this.logger.info("-------------------------\\Warning/-------------------------");
        }
    }

    private boolean checkProxy() {
        Path proxyModeEnabled = this.plugin.getDataFolder().resolve("enableProxyMode.txt");
        Path proxyModeDisabled = this.plugin.getDataFolder().resolve("disableProxyMode.txt");
        if (Files.exists(proxyModeEnabled, new LinkOption[0])) {
            return true;
        }
        if (Files.exists(proxyModeDisabled, new LinkOption[0])) {
            return false;
        }
        return this.serverAdapter.determineProxy();
    }

    public void startupPlatform(SRServerPlatformInit init) throws InitializeException {
        init.initMetricsJoinListener();
        init.initPermissions();
        init.initGUIListener();
        if (this.proxyMode) {
            if (Files.exists(this.plugin.getDataFolder().resolve("enableSkinStorageAPI.txt"), new LinkOption[0])) {
                this.plugin.loadStorage();
                this.plugin.registerAPI();
                init.postAPIInitHook();
            }
            init.initMessageChannel();
        } else {
            this.plugin.loadStorage();
            this.plugin.registerAPI();
            init.postAPIInitHook();
            this.plugin.initCommands();
            init.initLoginProfileListener();
        }
    }

    @Inject
    public SRServerPlugin(SRPlugin plugin, SRServerAdapter<?> serverAdapter, SRLogger logger) {
        this.plugin = plugin;
        this.serverAdapter = serverAdapter;
        this.logger = logger;
    }

    public boolean isProxyMode() {
        return this.proxyMode;
    }

    public void setProxyMode(boolean proxyMode) {
        this.proxyMode = proxyMode;
    }
}

